/*
  Copyright (C) 2003 <ryu@gpul.org>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric PINSON <cpinson@freesheep.org>
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include <osg/Texture2D>
#include <osgDB/ReadFile>

#include <cal3d/coresubmesh.h>
#include <cal3d/coremesh.h>

#include <osgCal/CoreModel>

using namespace osgCal;

//CoreModel::CoreModel() {}

CoreModel::CoreModel(const CoreModel& model, const osg::CopyOp& copyop) :
  Object(model, copyop)
{
}

CoreModel::~CoreModel()
{
  _calCoreModel.destroy();
}

void CoreModel::garbageCollect(void) 
{
  // remove textures if no other object references them
	std::vector<int> texturesIds;
	for(CoreMaterialId2Textures2D::iterator i = _coreMaterialId2Textures.begin();i != _coreMaterialId2Textures.end();i++)
		texturesIds.push_back(i->first);

	for(int i = 0;i <(int)texturesIds.size();i++) {
		CoreMaterialId2Textures2D::iterator t=_coreMaterialId2Textures.find(texturesIds[i]);
		Textures2D& textures = t->second;
    int reference_count = textures.empty() ? 0 : textures[0]->referenceCount();
    if(textures.empty() || reference_count == 1) {
      // sanity check
      for(Textures2D::iterator j = textures.begin();j != textures.end();j++)
				if((*j)->referenceCount() != reference_count) {
					CalError::setLastError(CalError::INVALID_HANDLE, __FILE__, __LINE__);
					return;
				}
			_coreMaterialId2Textures.erase(t);
    }
  }
}

CoreModel::Textures2D* CoreModel::getTextures2D(const std::string& name)
{
  int coreMaterialId = _calCoreModel.getCoreMaterialId(name);
  if(coreMaterialId < 0)
    return 0;
  return getTextures2D(coreMaterialId);
}

CoreModel::Textures2D* CoreModel::getTextures2D(int coreMaterialId)
{
  CalCoreMaterial *pCoreMaterial = _calCoreModel.getCoreMaterial(coreMaterialId);

  if(pCoreMaterial == 0) return 0;

  if(_coreMaterialId2Textures.find(coreMaterialId) == _coreMaterialId2Textures.end()) {

    if(pCoreMaterial == 0) {
	  CalError::setLastError(CalError::INVALID_HANDLE, __FILE__, __LINE__);
	  return 0;
    }

    Textures2D textures;
    int mapId;
    for(mapId = 0; mapId < pCoreMaterial->getMapCount(); mapId++) {
      std::string strFilename = pCoreMaterial->getMapFilename(mapId);
	  
      osg::Image *img = osgDB::readImageFile(strFilename);
      if(img == NULL) {
	CalError::setLastError(CalError::FILE_NOT_FOUND, __FILE__, __LINE__);
	return 0;
      }

      osg::Texture2D *texture = new osg::Texture2D();
      texture->setImage(img);
      texture->setWrap(osg::Texture2D::WRAP_T, osg::Texture2D::REPEAT);
      texture->setWrap(osg::Texture2D::WRAP_S, osg::Texture2D::REPEAT);
      textures.push_back(texture);
    }
    _coreMaterialId2Textures[coreMaterialId] = textures;
  }

  return &_coreMaterialId2Textures[coreMaterialId];
}


void CoreModel::SubUsingMeshId(int coreMeshId) 
{
  int nb=0;
  std::map<int,int>::iterator it;
  it=_mReferenceCountCoreMeshIds.find(coreMeshId);
  if (it==_mReferenceCountCoreMeshIds.end())
    assert(0 && "error coreMeshId not found in list of referenced coreMeshId");
  nb=(*it).second;
  if (nb==1) {
    _mReferenceCountCoreMeshIds.erase(it);
    if (_calCoreModel.unloadCoreMesh(coreMeshId)==-1)
      assert(0 && "can't unload coreMeshId");
  }

}

void CoreModel::AddUsingMeshId(int coreMeshId) 
{
  if (_mReferenceCountCoreMeshIds.find(coreMeshId)==_mReferenceCountCoreMeshIds.end())
    _mReferenceCountCoreMeshIds[coreMeshId]=0; 
  _mReferenceCountCoreMeshIds[coreMeshId]++;
}
