/*
 * oregano-config.c
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <sys/types.h>
#include <dirent.h>

#include "main.h"
#include "oregano-config.h"
#include "load-library.h"
#include "dialogs.h"

#define OREGLIB_EXT	"oreglib"

static gboolean is_oregano_library_name (gchar* name);
static void load_library_error (gchar *name);

void
oregano_config_load (void)
{
	gnome_config_push_prefix ("/oregano/paths/");

	oregano.simexec = gnome_config_get_string ("sim_exec=/usr/bin/spice3");
	oregano.compress_files = gnome_config_get_bool ("compress_files=true");
	oregano.show_log = gnome_config_get_bool ("show_log=true");

	gnome_config_pop_prefix ();
}

void
oregano_config_save (void)
{
	gnome_config_push_prefix ("/oregano/paths/");

	gnome_config_set_string ("sim_exec", oregano.simexec);
	gnome_config_set_bool ("compress_files", oregano.compress_files);
	gnome_config_set_bool ("show_log", oregano.show_log);

	gnome_config_sync();
	gnome_config_pop_prefix ();
}

void 
oregano_lookup_libraries (void)
{
	gchar *fname;
	DIR *libdir;
	struct dirent *libentry;
	Library *library;

	/* FIXME: Either handle this in a correct way or (like this) don't allow changes during run-time... */
	if (oregano.libraries != NULL)
		return;

	oregano.libraries = NULL;

/*	tmp = g_get_current_dir ();
	fname = g_concat_dir_and_file (tmp, "default.oreglib");
	g_free (tmp);
	if (g_file_exists (fname)) {
		library = library_parse_xml_file (fname);
		oregano.libraries = g_list_append (oregano.libraries, library);
	}
	g_free (fname);
*/

	libdir = opendir (OREGANO_LIBRARYDIR);
	if (libdir == NULL) return;
	while ((libentry=readdir (libdir)) != NULL) {
		if (is_oregano_library_name (libentry->d_name)) {
			fname = g_concat_dir_and_file (OREGANO_LIBRARYDIR, 
					libentry->d_name);
			library = library_parse_xml_file (fname);
			
			if (library) 
				oregano.libraries = g_list_append (
							oregano.libraries, 
							library);
			else
				load_library_error (fname);
				
			g_free(fname);
		}
	}
}

/*
 * Helpers
 */
 
static gboolean
is_oregano_library_name (gchar *name)
{
	gchar *dot;
	
	dot = strchr (name, '.');
	if (dot == NULL || dot[1] == '\0') 
		return FALSE;
	
	dot++;	/* Points to the extension. */
	
	if (strcmp (dot, OREGLIB_EXT) == 0) 
		return TRUE;

	return FALSE;
}

static void 
load_library_error (gchar *name)
{
	gchar *msg;
	msg = g_strdup_printf (_("Could not read the parts library:\n%s\n\n"
			 "The file is probably corrupt. Please reinstall\n"
			 "the parts library or Oregano and try again."), name);
	oregano_error (msg);
	g_free (msg);
}
