class mongodb_slave ( $deploymentname = $uniqueid ) 
{
  include mongodb

  exec{ "create_${deploymentname}_dir":
    command => "mkdir -p /etc/mongodb/deployments/${deploymentname}",
    unless => "test -d /etc/mongodb/deployments/${deploymentname}",
  } -> File <<| tag == "mongodb_${deploymentname}" |>> { ensure => present, require => Exec["create_${deploymentname}_dir"] }

  package{"mongodb-stable": 
    alias => "mongodb",
    ensure => installed,
    require => [ Apt::Source["mongodb"], Exec["apt_update"] ],
  }

  file {"mongodb_config":
    name    => "/etc/mongodb.conf",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Package["mongodb"],
  }

  service {"mongodb":
    ensure => running,
    enable => true,
    subscribe => File["mongodb_config"],
    hasstatus => true,
    require => Package["mongodb"],
  }

  exec{"mongodb_role":
    command => "/bin/sed -i /etc/mongodb.conf -e s/#slave/slave/",
    onlyif => "test -e /etc/mongodb/deployments/${deploymentname}/dbhost.deployment_data",
    require => [ Package["mongodb"], Exec["create_${deploymentname}_dir"]],
  }

  exec{"mongodb_source":
    command => "/bin/sed -i /etc/mongodb.conf -e s/#source\ \=\ master.example.com/source\ \=\ `cat /etc/mongodb/deployments/${deploymentname}/dbhost.deployment_data`/",
    onlyif => "test -e /etc/mongodb/deployments/${deploymentname}/dbhost.deployment_data", 
    require => Exec["mongodb_role"],
    notify => Service["mongodb"]
  }

}
