#ifndef DB_H
#define DB_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "router.h"

/*
 * Create an RRD database for each interface in the list. Return NULL if
 * successful, the error message otherwise.
 */
extern const char *db_create (const char *path,const router_t *router);

/*
 * Update the RRD database associated with each interface in the list.
 * Return NULL if successful, the error message otherwise.
 */
extern const char *db_update (const char *path,const router_t *router);

/*
 * Generate I/O graph from specified RRD database. Return NULL
 * if successful, the error message otherwise.
 */
extern const char *db_graph_io (int *width,int *height,const char *pngfile,const char *database);

/*
 * Generate Alerts graph from specified RRD database. Return NULL
 * if successful, the error message otherwise.
 */
extern const char *db_graph_alerts (int *width,int *height,const char *pngfile,const char *database);

/*
 * Generate Status graph from specified RRD database. Return NULL
 * if successful, the error message otherwise.
 */
extern const char *db_graph_status (int *width,int *height,const char *pngfile,const char *database);

#endif	/* #ifndef DB_H */
