/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  ORBit-C++: C++ bindings for ORBit.
 *
 *  Copyright (C) 2000 Andreas Kloeckner
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author:	Andreas Kloeckner <ak@ixion.net>
 *  		Bowie Owens <bowie.owens@csiro.au>
 *
 *  Purpose:	IDL compiler type representation for types within an
 *  		inhibit block.
 *
 *
 */
#ifndef IDLInhibited_h_
#define IDLInhibited_h_

#include "IDLType.h"


template <class Base>
class IDLInhibited :
	public Base {
	std::string ident_;
	std::string qident_;
	std::string qcident_;
public:
	IDLInhibited(IDL_tree ident)
	:	ident_ (IDL_IDENT (ident).str)
	{
		IDL_tree ns_ident = IDL_IDENT_TO_NS(ident);
		g_assert (IDL_NODE_TYPE (ns_ident) == IDLN_GENTREE);

		IDL_tree l = IDL_ns_qualified_ident_new (ns_ident);
		bool first = true;
		for (IDL_tree q = l; q != NULL; q = IDL_LIST (q).next) {
			g_assert (IDL_NODE_TYPE (q) == IDLN_LIST);
			IDL_tree i = IDL_LIST (q).data;
			g_assert (IDL_NODE_TYPE (i) == IDLN_IDENT);
			g_assert(IDL_IDENT (i).str != NULL);

			if (strlen(IDL_IDENT (i).str) == 0)
				continue;

			if (!first) {
				qident_.append("::");
				qcident_.append("_");
			}
			first = false;

			qident_.append(IDL_IDENT (i).str);
			qcident_.append(IDL_IDENT (i).str);
		}
	}

	std::string get_c_typename() const { return qcident_; }
	std::string get_cpp_typename() const { return qident_; }
	std::string get_cpp_identifier() const { return  ident_; }
};



#endif

