/*
 *   
 *   Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
 *   trade-off using rainbow tables. 
 *   
 *   Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
 *   Hochreutiner, Andreas Huber and Etienne Dysli.
 *   
 *   Copyright (c) 2008 Philippe Oechslin, Cedric Tissieres, Bertrand Mesot
 *   
 *   Ophcrack is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   Ophcrack is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Ophcrack; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *   
 *   This program is released under the GPL with the additional exemption 
 *   that compiling, linking, and/or using OpenSSL is allowed.
 *   
 *   
 *   $Rev: 114 $
 *   $Date: 2008-04-28 15:54:03 +0200 (Mon, 28 Apr 2008) $
 *   
 *   
*/
#include <assert.h>

#include "hashmodel.h"
#include "list.h"
#include "hash.h"
#include "misc.h"
//---------------------------------------------------------------------------
HashModel::HashModel(QObject *parent) : QStandardItemModel(0, 6, parent) {
  // Set the header.

  setHorizontalHeaderItem(0, new QStandardItem("User"));
  setHorizontalHeaderItem(1, new QStandardItem("LM Hash"));
  setHorizontalHeaderItem(2, new QStandardItem("NT Hash"));
  setHorizontalHeaderItem(3, new QStandardItem("LM Pwd 1"));
  setHorizontalHeaderItem(4, new QStandardItem("LM Pwd 2"));
  setHorizontalHeaderItem(5, new QStandardItem("NT Pwd"));

  for (int i=0; i<columnCount(); ++i) {
    QStandardItem *item = horizontalHeaderItem(i);
    item->setTextAlignment(Qt::AlignCenter);
  }
}
//---------------------------------------------------------------------------
void HashModel::insertHash(hash_t *hsh) {
  assert(hsh != 0);

  int nrows = rowCount();
  int ncols = columnCount();
  int id = hsh->id;

  QStandardItem *item = itemFromId.value(id);

  if (item == 0) {
    for (int i=ncols-1; i>=0; --i) {
      item = new QStandardItem();
      item->setData(int(id), Qt::UserRole);
      setItem(nrows, i, item);
    }

    itemFromId.insert(id, item);
  }

  updateHash(hsh);
}
//---------------------------------------------------------------------------
void HashModel::insertHashes(list_t *hashes) {
  list_nd_t *nd;

  for (nd = hashes->head; nd != 0; nd = nd->prev) {
    hash_t *hsh = (hash_t*)nd->data;
    insertHash(hsh);
  }
}
//---------------------------------------------------------------------------
void HashModel::updateHash(hash_t *hsh, bool notFound) {
  int id = hsh->id;
  QStandardItem *root = itemFromId.value(id);

  if (root == 0) return;

  // Set the user name.

  int row = indexFromItem(root).row();
  item(row, 0)->setText(hsh->info);

  // Set the hash and password.

  int idx_txt = 0, idx_pwd = 0;

  switch (hsh->kind) {
  case lm1:
    idx_txt = 1;
    idx_pwd = 3;
    break;

  case lm2:
    idx_txt = 1;
    idx_pwd = 4;
    break;

  case nt:
    idx_txt = 2;
    idx_pwd = 5;
    break;
  }

  item(row, idx_txt)->setText(hsh->str);
    
  if (hsh->pwd[0] != 0) {
    item(row, idx_pwd)->setText(hsh->pwd);
    item(row, idx_pwd)->setForeground(QColor(0, 0, 0));
  }

  else if (hsh->done > 0) {
    item(row, idx_pwd)->setText("empty");
    item(row, idx_pwd)->setForeground(QColor(0, 0, 255));
  }
  
  else if (hsh->done <= 0) {
    if (notFound) {
      item(row, idx_pwd)->setText("not found");
      item(row, idx_pwd)->setForeground(QColor(255, 0, 0));
    } else {
      item(row, idx_pwd)->setText("");
      item(row, idx_pwd)->setForeground(QColor(0, 0, 0));
    }
  }

  // If the 1st LM hash is not connected to a NT hash, then we
  // display the NT password as empty.

  if (hsh->kind == lm1 && hsh->lmhsh1 == 0) {
    item(row, 5)->setText("empty");
    item(row, 5)->setForeground(QColor(0, 0, 255));
  }
}
//---------------------------------------------------------------------------
bool HashModel::removeRow(int row) {
  QStandardItem *root = item(row, 0);
  int id = root->data(Qt::UserRole).toInt();
  
  itemFromId.remove(id);

  return QStandardItemModel::removeRow(row);
}
