/*

    Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
    trade-off using rainbow tables. 
    
    Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
    Hochreutiner, Andreas Huber and Etienne Dysli.

    Copyright 2006 Philippe Oechslin, Cedric Tissieres

    Ophcrack is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Ophcrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Ophcrack; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

    This program is released under the GPL with the additional exemption 
    that compiling, linking, and/or using OpenSSL is allowed.
*/

/* LanManager/NTLM password cracker using a Time-Memory Trade-Off */

/* 
 * $Log: main.c,v $
 * Revision 2.3.3 2006/10/11 tissieres
 * save tables directory
 *
 * Revision 2.3.1 2006/07/30 tissieres
 * Fit screen for small resolution
 *
 * Revision 2.2 2006/03/20 tissieres
 * Support for livecd version
 *
 * Revision 2.1  2005/12/06 tissieres
 * Added tables modification feature
 *
 * Revision 2.0  2005/03/24 tissieres
 * Initial revision
 *
 */


/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#ifdef LIVECD
#include "ophcrack.h"
#endif

GtkWidget *main_window;

int
main (int argc, char *argv[])
{
  extern char directory[];
  FILE *configfile;
  char config_filename[300];
  char *line = (char *)malloc(100*sizeof(char));
  char *parameter;

  gint pwidth, pheight, width, height;
  gtk_set_locale ();
  gtk_init (&argc, &argv);

#ifndef WIN32
  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  add_pixmap_directory ("../pixmaps");
#else
  add_pixmap_directory("pixmaps");
#endif

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  main_window = create_main_window ();
  
  /* Resize window if it doesn't fit the screen - Thanks to icedgreen */
  /* if main window is bigger than the current screen shrink to fit */
  width=gdk_screen_width();
  height=gdk_screen_height();
  gtk_window_get_size(GTK_WINDOW(main_window), &pwidth, &pheight);
  if (pwidth>width || pheight>height) {
    gtk_window_maximize(GTK_WINDOW(main_window));
  }
  
  gtk_widget_show (main_window);
  create_model();

#ifdef WIN32
  sprintf(config_filename, "%s\\config.ini", g_win32_get_package_installation_directory (NULL, NULL));
#else
  sprintf(config_filename, "%s/%s/config.ini", PACKAGE_DATA_DIR, PACKAGE);
#endif

  if ((configfile=fopen((char *)config_filename,"r"))) {
    while (fgets(line, 99, configfile) != NULL ) {
      parameter = (char *)strsep(&line,"=");
      if (!strcmp(parameter, "table_dir")){
	strcpy(directory, line);
	directory[strlen(directory)-1] = 0; //remove newline
	auto_detect_tables(directory); 
      }
    }
    fclose(configfile);
  } else
    find_tables();
  
#ifdef LIVECD
  {
    GtkFunction *func_ptr;
    func_ptr = (GtkFunction *)&init_livecd; 
    if (argc == 2)
      gtk_init_add((GtkFunction)func_ptr, argv[1]);
  }
#endif 
  gtk_main ();

  return 0;
}

