/*

    Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
    trade-off using rainbow tables. 
    
    Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
    Hochreutiner, Andreas Huber and Etienne Dysli.

    Copyright 2006 Philippe Oechslin, Cedric Tissieres

    Ophcrack is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Ophcrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Ophcrack; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

    This program is released under the GPL with the additional exemption 
    that compiling, linking, and/or using OpenSSL is allowed.
*/

/* Callbacks functions for the GUI */

/* 
 * $Log: callbacks.c,v $
 * Revision 2.3.4 2007/02/19 tissieres
 * bkhive-1.1.0, show_dialog
 *
 * Revision 2.3.3 2006/10/11 tissieres
 * bkhive2, save tables directory, error msg when no tables
 *
 * Revision 2.3.2 2006/10/10 tissieres
 * New pwdump6 version, fixed display bug, fixed bkhive bug
 *
 * Revision 2.3  2006/07/21 tissieres oechslin
 * Help added, pwdump6 support, tables management, statusbar changed
 *
 * Revision 2.2  2006/03/20 tissieres
 * Tables management improved
 *
 * Revision 2.1  2005/12/06 tissieres
 * Added tables function
 *
 * Revision 2.0  2005/03/24  tissieres
 * Initial revision
 *
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#ifndef WIN32
#include <sys/times.h>
#else /* WIN32 */
#include <sys/time.h>
#include <windows.h>
#endif /* WIN32 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "ophcrack.h"
#include "make_redux.h"

extern GtkWidget *main_window;
GtkWidget* fs;
GtkWidget* popup_menu;
GtkWidget* remote_dialog;
GtkWidget* fc;
GtkWidget* fc2;
GtkCellRenderer     *renderer;
GtkListStore *list_store;
GtkListStore *list_store2;
GtkWidget* about_window;
GtkWidget* ts;
GtkWidget* table_dialog;
GtkWidget* load_hash_dialog;
GtkWidget* readahead_window;
GtkWidget* help_window;

extern char directory[128];
extern int cols;
extern int batch_tables;
extern int offset;
extern int last_table;
extern int crack_type;
extern int chkpt1;
extern int chkpt2;

int fill_tree(void);
void clear_buffer(void);

void
on_load_file1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  fs = create_fileselection();
  gtk_widget_show(fs);
  gtk_widget_set_sensitive(main_window, 0);
  
}


void
on_launch1_toggled                     (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{
  extern int STOP;
  extern int batch_tables;
  GtkWidget* tmp_image;
  GtkWidget *toolbar1;
  GtkIconSize tmp_toolbar_icon_size;
  GtkWidget *tmp;
  
  toolbar1 = lookup_widget (GTK_WIDGET(user_data), "toolbar1");
  tmp_toolbar_icon_size = gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar1));
  
  if (gtk_toggle_tool_button_get_active(GTK_TOGGLE_TOOL_BUTTON(user_data))) {
    gtk_tool_button_set_label(GTK_TOOL_BUTTON(user_data), "Stop");
    tmp_image = gtk_image_new_from_stock ("gtk-stop", tmp_toolbar_icon_size);
    gtk_widget_show (tmp_image);
    gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (user_data), tmp_image);
    STOP = 0;

    tmp = lookup_widget(main_window, "dump1");
    gtk_widget_set_sensitive(tmp, 0);
    tmp = lookup_widget(main_window, "deletebutton");
    gtk_widget_set_sensitive(tmp, 0);
    tmp = lookup_widget(main_window, "save_button");
    gtk_widget_set_sensitive(tmp, 0);
    tmp = lookup_widget(main_window, "exit1");
    gtk_widget_set_sensitive(tmp, 0);
    tmp = lookup_widget(main_window, "tablebutton");
    gtk_widget_set_sensitive(tmp, 0);

    //    clear_buffer();
    if (main_cmd() == -2) {
      GtkWidget* error_dialog = create_dialog1();
      gtk_window_set_title (GTK_WINDOW (error_dialog), "Tables not found");
      tmp = lookup_widget(error_dialog, "label3");
      gtk_label_set_text(GTK_LABEL(tmp), "Error: Select tables directory first!");
      gtk_widget_show(error_dialog);
    }
      
    fill_tree();
    gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON (user_data), 0);
    
    tmp = lookup_widget(main_window, "dump1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "deletebutton");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "save_button");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "exit1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "tablebutton");
    gtk_widget_set_sensitive(tmp, 1);
  }
  else {
    gtk_tool_button_set_label(GTK_TOOL_BUTTON(user_data), "Launch");
    tmp_image = gtk_image_new_from_stock ("gtk-execute", tmp_toolbar_icon_size);
    gtk_widget_show (tmp_image);
    gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (user_data), tmp_image);
    STOP = 1;
    
    tmp = lookup_widget(main_window, "dump1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "deletebutton");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "save_button");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "exit1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "tablebutton");
    gtk_widget_set_sensitive(tmp, 1);    
   
  }
}

void
on_exit1_activate                      (GtkMenuItem     *menuitem,
					gpointer         user_data)
{
  gtk_main_quit();
  exit(0);
}


void
on_ok_button1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  extern hashes;
  GtkWidget *tmp;
  
  //char filename[200];
  //sprintf(filename, "%s\0", gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fc)));
  if (read_file(gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fs)))) {
    
    fill_tree();
    gtk_widget_destroy(fs);
    gtk_widget_set_sensitive(main_window, 1);
    tmp = lookup_widget(main_window, "launch1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "save_button");
    gtk_widget_set_sensitive(tmp, 1);
    
  }
  else {
    GtkWidget* error_dialog = create_dialog1();
    gtk_widget_show(error_dialog);
  }
}


void create_model(void) {
  
  
  GtkTreeViewColumn   *col;
  GtkWidget *hash_list;
  
  list_store = gtk_list_store_new (5, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
  hash_list = lookup_widget (main_window, "hash_list");
  
  gtk_tree_view_set_model(GTK_TREE_VIEW(hash_list), GTK_TREE_MODEL(list_store));

  //COLUMN 1
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "ID");
  
  /* pack tree view column into tree view */
  gtk_tree_view_append_column(GTK_TREE_VIEW(hash_list), col);

  renderer = gtk_cell_renderer_text_new();

  /* pack cell renderer into tree view column */
  gtk_tree_view_column_pack_start(col, renderer, TRUE);
  
  gtk_tree_view_column_add_attribute(col, renderer, "text", 0);

  //COLUMN 2
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "USERNAME/LMHASH");

  /* pack tree view column into tree view */
  gtk_tree_view_append_column(GTK_TREE_VIEW(hash_list), col);

  renderer = gtk_cell_renderer_text_new();

  /* pack cell renderer into tree view column */
  gtk_tree_view_column_pack_start(col, renderer, TRUE);

  gtk_tree_view_column_add_attribute(col, renderer, "text", 1);

  //COLUMN 3
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "LMpasswd1");

  /* pack tree view column into tree view */
  gtk_tree_view_append_column(GTK_TREE_VIEW(hash_list), col);

  renderer = gtk_cell_renderer_text_new();

  /* pack cell renderer into tree view column */
  gtk_tree_view_column_pack_start(col, renderer, TRUE);

  gtk_tree_view_column_add_attribute(col, renderer, "text", 2);

  //COLUMN 4
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "LMpasswd2");

  /* pack tree view column into tree view */
  gtk_tree_view_append_column(GTK_TREE_VIEW(hash_list), col);

  renderer = gtk_cell_renderer_text_new();

  /* pack cell renderer into tree view column */
  gtk_tree_view_column_pack_start(col, renderer, TRUE);
  
  gtk_tree_view_column_add_attribute(col, renderer, "text", 3);


  //COLUMN 5
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "NTpasswd");

  /* pack tree view column into tree view */
  gtk_tree_view_append_column(GTK_TREE_VIEW(hash_list), col);

  renderer = gtk_cell_renderer_text_new();

  /* pack cell renderer into tree view column */
  gtk_tree_view_column_pack_start(col, renderer, TRUE);

  gtk_tree_view_column_add_attribute(col, renderer, "text", 4);

}

int change_tree(int hash) {
  GtkWidget *hash_list;
  GtkTreeIter iter;
  gsize j;
  char temp[50];
  char line[6] = {0};
  
  extern char info[MAX_HASH+1][64], password[MAX_HASH+1][16], 
    password1[MAX_HASH+1][8], password2[MAX_HASH+1][8];
  extern unsigned char lm_hash1[MAX_HASH+1][8], 
    lm_hash2[MAX_HASH+1][8],
    nt_hash[MAX_HASH+1][16]; 
  extern int hashes, userid[MAX_HASH+1];  

  sprintf(line, "%d", hash);
  gtk_tree_model_get_iter_from_string (GTK_TREE_MODEL(list_store), &iter, line);

  if (info[hash][0])
    gtk_list_store_set(list_store, &iter, 0, userid[hash], 1, g_convert(info[hash], -1, "UTF-8", "ISO_8859-1", NULL, &j, NULL), 2, g_convert(password1[hash], -1, "UTF-8", "CP437", NULL, &j, NULL), 3, g_convert(password2[hash], -1, "UTF-8", "CP437", NULL, &j, NULL), 4, g_convert(password[hash], -1, "UTF-8", "CP437", NULL, &j, NULL), -1);
  else {
    for (j=0; j<8; j++) snprintf(temp+j*2,3,  "%02hhx",lm_hash1[hash][j]);
    for (j=0; j<8; j++) snprintf(temp+(8+j)*2,3, "%02hhx",lm_hash2[hash][j]);
    gtk_list_store_set(list_store, &iter, 0, hash, 1, temp, 2, g_convert(password1[hash], -1, "UTF-8", "CP437", NULL, &j, NULL), 3, g_convert(password2[hash], -1, "UTF-8", "CP437", NULL, &j, NULL), 4, g_convert(password[hash], -1, "UTF-8", "CP437", NULL, &j, NULL), -1);
  }
  return 1;
}


int fill_tree(void) {
  int i;
  gsize j;
  GtkTreeIter   iter;
  char temp[50];

  extern char info[MAX_HASH+1][64], password[MAX_HASH+1][16], 
    password1[MAX_HASH+1][8], password2[MAX_HASH+1][8];
  extern unsigned char lm_hash1[MAX_HASH+1][8], 
    lm_hash2[MAX_HASH+1][8],
    nt_hash[MAX_HASH+1][16]; 
  extern int hashes, userid[MAX_HASH+1];

  gtk_list_store_clear(list_store);
  
  for (i=0; i<hashes; i++) {

    /* Append an empty row to the list store. Iter will point to the new row */
    gtk_list_store_append(list_store, &iter);

    if (info[i][0])
      gtk_list_store_set(list_store, &iter, 0, userid[i], 1, g_convert(info[i], -1, "UTF-8", "ISO_8859-1", NULL, &j, NULL), 2, g_convert(password1[i], -1, "UTF-8", "CP437", NULL, &j, NULL), 3, g_convert(password2[i], -1, "UTF-8", "CP437", NULL, &j, NULL), 4, g_convert(password[i], -1, "UTF-8", "CP437", NULL, &j, NULL), -1);
    else {
      for (j=0; j<8; j++) snprintf(temp+j*2,3,  "%02hhx",lm_hash1[i][j]);
      for (j=0; j<8; j++) snprintf(temp+(8+j)*2,3, "%02hhx",lm_hash2[i][j]);
      gtk_list_store_set(list_store, &iter, 0, i, 1, temp, 2, g_convert(password1[i], -1, "UTF-8", "CP437", NULL, &j, NULL), 3, g_convert(password2[i], -1, "UTF-8", "CP437", NULL, &j, NULL), 4, g_convert(password[i], -1, "UTF-8", "CP437", NULL, &j, NULL), -1);
    }
  }
  return 1;
}

void clear_buffer(void) {
  GtkWidget * textview1;
  GtkTextBuffer* stats;  
  GtkTextIter *start, *end;

  textview1 = lookup_widget(main_window, "textview1");
  stats = gtk_text_view_get_buffer (GTK_TEXT_VIEW(textview1));
  gtk_text_buffer_get_bounds(stats, start, end);
  gtk_text_buffer_delete(stats, start, end);

}

void print_stats(void) {
  extern int n_search,
    n_fseek,
    n_hashredux,
    n_false,
    n_false_redux,
    n_match,
    n_loop,
    n_found;
  
  extern struct tms n_times;
  extern int ticks;
  extern clock_t n_start_time, laps_time; 
  
  
  char tmp[200];
  GtkTextBuffer* stats;
  GtkWidget * textview1;
  textview1 = lookup_widget(main_window, "textview1");
  GtkTextIter iter;
  stats = gtk_text_buffer_new(NULL);
  gtk_text_view_set_buffer (GTK_TEXT_VIEW(textview1), stats);
  gtk_text_buffer_get_iter_at_offset(stats, &iter, -1);


  clock_t t;
  
#ifndef WIN32
  t = times(&n_times);
#else /* WIN32 */
  t = clock();
#endif /* WIN32 */
  
  sprintf(tmp, "Statistics: \n hash-redux calculations: %d\n",
	  n_hashredux);
  gtk_text_buffer_insert(stats,&iter, tmp, -1);
  sprintf(tmp," endpoint searched %d\n fseek operations %d\n",
	 n_search, n_fseek);
  gtk_text_buffer_insert(stats,&iter, tmp, -1);
  sprintf(tmp," matches found %d\n false alarms %d\n",
	 n_match,
	 n_false);
  gtk_text_buffer_insert(stats,&iter, tmp, -1);
  sprintf(tmp," hash-redux operations per false alarms %d\n",
	 (n_false? n_false_redux/n_false: 0));
  gtk_text_buffer_insert(stats,&iter, tmp, -1);
  sprintf(tmp," time elapsed %5.2fs\n\n", 
	 (float)(t-n_start_time)/ ticks );
  gtk_text_buffer_insert(stats,&iter, tmp, -1);
}
 
void write_table_name_from_type(int type, char *buf) {

  switch(type) {
  case REDUX_LM_ALPHANUM10k:
  case REDUX_LM_ALPHANUM5k:
    sprintf(buf, "LM alphanum");
    break;
  case REDUX_LM_EXTENDED:
    sprintf(buf, "LM extended");
    break;
  case REDUX_NT_EXTENDED:
    sprintf(buf, "NT mixed");
    break;
  case REDUX_LM_GERMAN:
    sprintf(buf, "LM german");
    break;
  }
  
}
 
void update_statusbar(int k) {
  extern clock_t n_start_time, laps_time; 
  extern struct tms n_times;  
  extern int first_table, last_table, cols, n_found, hashes, ticks;
  
  GtkWidget * status_bar;
  gint context_id;
  gchar *buff;
  gchar buff2[50]={0};
  
  write_table_name_from_type(crack_type, buff2);

  status_bar = lookup_widget(GTK_WIDGET(main_window), "statusbar1");
  context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(status_bar), "");
  
#ifndef WIN32
  laps_time = times(&n_times);
#else /* WIN32 */
  laps_time = clock();
#endif /* WIN32 */
  
  buff = g_strdup_printf (" Table set: %s | Tables in use: %d to %d :%2d%% | Passwords:%d/%d | Time elapsed: %.2f", buff2, first_table+1, last_table+1, 100-(100*k)/cols, n_found, hashes, (float)(laps_time - n_start_time)/ticks);
  
  gtk_statusbar_push (GTK_STATUSBAR (status_bar), context_id, buff);
  g_free (buff);
}

void
on_dump1_clicked                       (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  int event_time;
  GtkWidget *tmp;

  popup_menu = create_menu1();
  event_time = gtk_get_current_event_time();

#ifndef WIN32 
  tmp = lookup_widget(popup_menu, "local_pwdump1");
  gtk_container_remove (GTK_CONTAINER (popup_menu), tmp);
  tmp = lookup_widget(popup_menu, "remote_pwdump1");
  gtk_container_remove (GTK_CONTAINER (popup_menu), tmp);
#endif

  gtk_menu_popup(GTK_MENU(popup_menu), NULL, NULL, NULL, NULL, 0, event_time);

}


void
on_ok_button2_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{

  char *filename;
  char command[500];
#ifndef WIN32
  char tmp_file[] = "/tmp/ophcrack.tmp";
  char tmp_file2[] = "/tmp/ophcrack2.tmp";
#else
  char temp_path[450];
  char tmp_file[500]; 
  char tmp_file2[500];
#endif  
  GtkWidget *tmp;
  
  filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fc));
#ifndef WIN32
  sprintf(command, "bkhive \"%s/SYSTEM\" %s 2>&1 1>/dev/null", filename, tmp_file2);
  system(command);
  sprintf(command, "samdump2 \"%s/SAM\" %s > %s 2>/dev/null",  filename, tmp_file2, tmp_file);
#else /* WIN32 */
  GetTempPath(449, temp_path);
  sprintf(tmp_file, "%sophcrack.tmp", temp_path);
  sprintf(tmp_file2, "%sophcrack2.tmp", temp_path);
  sprintf(command, "..\\win32_tools\\bkhive \"%s\\SYSTEM\" \"%s\"", filename, tmp_file2);
  system(command);
  sprintf(command, "..\\win32_tools\\samdump2 \"%s\\SAM\" \"%s\" > \"%s\"",  filename, tmp_file2, tmp_file);
#endif

  system(command);
  if (read_file(tmp_file)) {
    fill_tree();
    unlink(tmp_file);
    unlink(tmp_file2);

    gtk_widget_destroy(fc);

    gtk_widget_set_sensitive(main_window, 1);
    tmp = lookup_widget(main_window, "launch1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "save_button");
    gtk_widget_set_sensitive(tmp, 1);

  }
  else {
    unlink(tmp_file);
    GtkWidget* error_dialog = create_dialog1();
    gtk_widget_show(error_dialog);
  }
}



void
on_save_ok_button_clicked              (GtkButton   *button,
                                        gpointer         user_data)
{
  extern char info[MAX_HASH+1][64], password[MAX_HASH+1][16], 
    password1[MAX_HASH+1][8], password2[MAX_HASH+1][8];
  extern unsigned char lm_hash1[MAX_HASH+1][8], 
    lm_hash2[MAX_HASH+1][8],
    nt_hash[MAX_HASH+1][16]; 
  extern int hashes, userid[MAX_HASH+1];
  

  int i,h;
  char *filename;
  FILE *save_file;
  unsigned char *tmp;

  filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fc2));
  if (access(filename, F_OK) == 0)
    unlink(filename);

  save_file = fopen(filename, "w");

  for (h=0; h<hashes; h++) {

    if (info[h][0])
      fprintf(save_file,"%s",info[h]);
    fprintf(save_file,":");
    if (userid[h])
      fprintf(save_file,"%d", userid[h]);
    fprintf(save_file, ":");
    for (i=0; i<8; i++) fprintf(save_file,"%02hhx",lm_hash1[h][i]);
    for (i=0; i<8; i++) fprintf(save_file,"%02hhx",lm_hash2[h][i]);
    fprintf(save_file,":");
    if (strcmp(nt_hash[h],""))
      for (i=0; i<16; i++) fprintf(save_file,"%02hhx",nt_hash[h][i]);
    fprintf(save_file,":");
    /* thanks to BaLP */
    for (tmp = (unsigned char *)password1[h]; *tmp && (*tmp == ':' ? 
      fprintf(save_file, "%c", 193) : fprintf(save_file, "%c", *tmp)); tmp++);
    fprintf(save_file,":");
    for (tmp = (unsigned char *)password2[h]; *tmp && (*tmp == ':' ? 
      fprintf(save_file, "%c", 193) : fprintf(save_file, "%c", *tmp)); tmp++);
    fprintf(save_file,":");
    for (tmp = (unsigned char *)password[h]; *tmp && (*tmp == ':' ? 
      fprintf(save_file, "%c", 193) : fprintf(save_file, "%c", *tmp)); tmp++);
    fprintf(save_file, "\n");
  }
  fclose(save_file);
  gtk_widget_destroy(fc2);
}


void
on_save_button_clicked                  (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  char current_dir[200];
   
  fc2 = create_filechooserdialog2();
  getcwd(current_dir, 200);
  gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(fc2), current_dir);
  gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(fc2), "save.oph");
  gtk_widget_show(fc2);
  gtk_widget_set_sensitive(main_window, 0);
}

void
on_cancel_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(fs);
  gtk_widget_set_sensitive(main_window, 1);

}

void
on_cancel_button2_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(fc);
  gtk_widget_set_sensitive(main_window, 1);
}


void
on_about_button_clicked                (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  GdkColor blank = {0, 65535, 65535, 65535};
  gint x, y, pwidth, pheight, width, height;
  GtkWidget *temp;

  gtk_widget_set_sensitive(main_window, 0);
  about_window = create_about_window();
  temp = lookup_widget(about_window, "about_close_button");
  gtk_widget_modify_bg(GTK_WIDGET(about_window), GTK_STATE_NORMAL, &blank);
  gtk_widget_modify_bg(temp, GTK_STATE_PRELIGHT, &blank);
  temp = lookup_widget(about_window, "about_text");
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW(temp), 0);
  gtk_window_set_decorated(GTK_WINDOW(about_window), FALSE);

  gtk_window_get_position(GTK_WINDOW(main_window), &x, &y);
  gtk_window_get_size(GTK_WINDOW(main_window), &pwidth, &pheight);
  gtk_window_get_size(GTK_WINDOW(about_window), &width, &height);

  x = (pwidth - width) / 2 + x;
  y = (pheight - height) / 2 + y;

  gtk_widget_show(about_window);
  gtk_window_move(GTK_WINDOW(about_window), x, y);

  
}

void
on_about_close_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(about_window);
  gtk_widget_set_sensitive(main_window, 1);
  
}

void
on_from__sam_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  fc = create_filechooserdialog1();
  gtk_widget_show(fc);
  gtk_widget_set_sensitive(main_window, 0);
}


void
on_local_pwdump1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef WIN32
  FILE *tmpfile, *tmpfile2;
  char command[500];
  char tmp_file[] = "ophcrack.tmp";
  char buff[100];
  int n;
  GtkWidget *tmp;

  SetCurrentDirectory("..\\win32_tools");
  sprintf(command, "pwdump6.exe -o %s 127.0.0.1", tmp_file);
  //tmpfile = popen(command, "r");
  //tmpfile2 = fopen(tmp_file, "w");
  system(command);
  /*while ((n = fread(buff, 1, 100, tmpfile)))
    fwrite(buff, 1, n, tmpfile2);
  
  pclose(tmpfile);
  fclose(tmpfile2);
  */
  if (read_file(tmp_file)) {
    fill_tree();
    unlink(tmp_file);

    SetCurrentDirectory("..\\win32");
    tmp = lookup_widget(main_window, "launch1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "save_button");
    gtk_widget_set_sensitive(tmp, 1);
  }
  else {
    unlink(tmp_file);
    GtkWidget* error_dialog = create_dialog1();
    gtk_widget_show(error_dialog);
  }
#endif
}


void
on_remote_pwdump1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef WIN32
  GtkWidget* tmp;
  remote_dialog = create_dialog_remote_dump();
  gtk_widget_show(remote_dialog);
  tmp = lookup_widget(remote_dialog, "target_share");
  gtk_entry_set_text(GTK_ENTRY(tmp), "admin$");
  gtk_widget_set_sensitive(main_window, 0);
#endif

}

void
on_remote_cancel_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
#ifdef WIN32
  gtk_widget_destroy(remote_dialog);
  gtk_widget_set_sensitive(main_window, 1);
#endif
}


void
on_remote_ok_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
#ifdef WIN32
  char command[500];
  char tmp_file[] = "ophcrack.tmp";
  char hostname[100];
  char share[100];
  char user[100];
  int n, other_user = 0;
  GtkWidget *tmp;

  tmp = lookup_widget(remote_dialog, "target_hostname");
  sprintf(hostname,"%s", gtk_entry_get_text(GTK_ENTRY(tmp)));
  if (!strcmp(hostname, "")) {
    GtkWidget *error_dialog3 = create_dialog3();
    gtk_widget_show(error_dialog3);
  }
  else {
  
    tmp = lookup_widget(remote_dialog, "target_share");
    sprintf(share ,"%s",gtk_entry_get_text(GTK_ENTRY(tmp)));
    if (strcmp(user, ""))
      sprintf(share, "admin$");
    
    tmp = lookup_widget(remote_dialog, "target_user");
    sprintf(user,"%s",gtk_entry_get_text(GTK_ENTRY(tmp)));
    if (strcmp(user, "")) 
      other_user=1;
    

    if (other_user)
      sprintf(command, "..\\win32_tools\\pwdump6.exe -o %s -u %s -s %s %s", tmp_file, user, share, hostname);
    else
      sprintf(command, "..\\win32_tools\\pwdump6.exe -o %s -s %s %s", hostname, tmp_file, share);

    system(command);
    
    if (read_file(tmp_file)) {
      fill_tree();
      unlink(tmp_file);
      
      gtk_widget_destroy(remote_dialog);
      gtk_widget_set_sensitive(main_window, 1);
      tmp = lookup_widget(main_window, "launch1");
      gtk_widget_set_sensitive(tmp, 1);
      tmp = lookup_widget(main_window, "save_button");
      gtk_widget_set_sensitive(tmp, 1);
    }
    else {
      unlink(tmp_file);
      GtkWidget* error_dialog = create_dialog1();
      gtk_widget_show(error_dialog);
    }
  }
#endif
}


void
on_dialog_remote_dump_close            (GtkDialog       *dialog,
                                        gpointer         user_data)
{
#ifdef WIN32
  gtk_widget_destroy(remote_dialog);
  gtk_widget_set_sensitive(main_window, 1);
#endif
}


void
on_filechooserdialog1_close            (GtkDialog       *dialog,
                                        gpointer         user_data)
{
  gtk_widget_destroy(fc);
  gtk_widget_set_sensitive(main_window, 1);

}


void
on_filechooserdialog2_close            (GtkDialog       *dialog,
                                        gpointer         user_data)
{

  gtk_widget_destroy(fc2);
  gtk_widget_set_sensitive(main_window, 1);


}


void
on_fileselection_close                 (GtkDialog       *dialog,
                                        gpointer         user_data)
{
  gtk_widget_destroy(fs);
  gtk_widget_set_sensitive(main_window, 1);

}


void
on_tablebutton_activate                (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  GtkWidget *tmp;
  GtkCellRenderer *renderer2;
  GtkTreeViewColumn *col;
  GtkTreeIter iter;
  char buf[5];

  table_dialog = create_table_dialog();
  gtk_widget_show(table_dialog);
  gtk_widget_set_sensitive(main_window, 0);

  tmp = lookup_widget(table_dialog, "entry_directory");
  if (strcmp(directory, "") !=0)
    gtk_entry_set_text(GTK_ENTRY(tmp), directory);

  tmp = lookup_widget(table_dialog, "table_type_list");
  list_store2 = gtk_list_store_new (1, G_TYPE_STRING);
  
  gtk_tree_view_set_model(GTK_TREE_VIEW(tmp), GTK_TREE_MODEL(list_store2));
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "ID");
  
  /* pack tree view column into tree view */
  gtk_tree_view_append_column(GTK_TREE_VIEW(tmp), col);

  renderer2 = gtk_cell_renderer_text_new();
  gtk_tree_view_column_pack_start(col, renderer2, TRUE);
  gtk_tree_view_column_add_attribute(col, renderer2, "text", 0);

  gtk_list_store_clear(list_store2);

  gtk_list_store_append(list_store2, &iter);
  gtk_list_store_set(list_store2, &iter, 0, "LM: Alphanumeric SSTIC04-10k (388MB)", -1);
  gtk_list_store_append(list_store2, &iter);
  gtk_list_store_set(list_store2, &iter, 0, "LM: Alphanumeric SSTIC04-5k (720MB)", -1);
  gtk_list_store_append(list_store2, &iter);
  gtk_list_store_set(list_store2, &iter, 0, "LM: Extended (alphanum + 33 special)", -1);
  gtk_list_store_append(list_store2, &iter);
  gtk_list_store_set(list_store2, &iter, 0, "LM: German chars", -1);
  gtk_list_store_append(list_store2, &iter);
  gtk_list_store_set(list_store2, &iter, 0, "NT: (6 ext, 7 alphanum, 8 lowalpha-num)", -1);

  if (crack_type >=0) {
    sprintf(buf, "%d", crack_type);
    gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(list_store2), &iter, buf);
    gtk_tree_selection_select_iter(gtk_tree_view_get_selection(GTK_TREE_VIEW(tmp)), &iter);  
  } else 
    if (strcmp(directory, "") !=0) 
      if (auto_detect_tables(directory)) {
	tmp = lookup_widget(table_dialog, "entry_directory");
	gtk_entry_set_position(GTK_ENTRY(tmp), -1);
	
	tmp = lookup_widget(table_dialog, "table_type_list");
	sprintf(buf, "%d", crack_type);
	gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(list_store2), &iter, buf);
	gtk_tree_selection_select_iter(gtk_tree_view_get_selection(GTK_TREE_VIEW(tmp)), &iter);  
      }
}  



void
on_table_dialog_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(table_dialog);
  gtk_widget_set_sensitive(main_window, 1);

}

void
on_cancel_table_dialog_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(table_dialog);
  gtk_widget_set_sensitive(main_window, 1);
}


void
on_ok_table_dialog_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *tmp;
  unsigned char filename[256];
  extern int open_tables;
  char *parameter;
  FILE *configfile;
  char config_filename[300];
  
  char *line = (char *)malloc(100*sizeof(char)); 

  tmp = lookup_widget(table_dialog, "entry_directory");
  sprintf(directory, "%s", gtk_entry_get_text(GTK_ENTRY(tmp)));

#ifdef WIN32
  sprintf(config_filename, "%s\\config.ini", g_win32_get_package_installation_directory (NULL, NULL));
#else
  sprintf(config_filename, "%s/%s/config.ini", PACKAGE_DATA_DIR, PACKAGE);
#endif

  if ((configfile=fopen((char *)config_filename,"w"))) {
#ifdef WIN32
    fprintf(configfile, "table_dir=%s\n", gtk_entry_get_text(GTK_ENTRY(tmp)));
#else
    fprintf(configfile, "table_dir=%s\n", gtk_entry_get_text(GTK_ENTRY(tmp)));
#endif
    fclose(configfile);
  }
  
  gtk_widget_destroy(table_dialog);
  gtk_widget_set_sensitive(main_window, 1);
  
  open_tables=0;

}


void
on_button_directory_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{

  ts = create_tableselection();
  gtk_widget_show(ts);
  gtk_widget_set_sensitive(table_dialog, 0);

}

void
on_cancel_ts_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(ts);
  gtk_widget_set_sensitive(main_window, 0);
  gtk_widget_set_sensitive(table_dialog, 1);

}


void
on_ok_ts_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *tmp;
  char buf[5];
  GtkTreeIter iter;

  if (auto_detect_tables(gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (ts)))) {
    tmp = lookup_widget(table_dialog, "entry_directory");
    gtk_entry_set_text(GTK_ENTRY(tmp), gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (ts)));
    gtk_entry_set_position(GTK_ENTRY(tmp), -1);
    
    tmp = lookup_widget(table_dialog, "table_type_list");
    sprintf(buf, "%d", crack_type);
    gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(list_store2), &iter, buf);
    gtk_tree_selection_select_iter(gtk_tree_view_get_selection(GTK_TREE_VIEW(tmp)), &iter);  
  
    gtk_widget_destroy(ts);
    gtk_widget_set_sensitive(main_window, 0);
    gtk_widget_set_sensitive(table_dialog, 1);
    
  }
  else {
    GtkWidget* error_dialog = create_dialog1();
    gtk_window_set_title (GTK_WINDOW (error_dialog), "Tables not found");
    tmp = lookup_widget(error_dialog, "label3");
    gtk_label_set_text(GTK_LABEL(tmp), "Error: No known tables were found in the directory selected");
    gtk_widget_show(error_dialog);
  }
  
}


void
on_tableselection_close                (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(ts);
  gtk_widget_set_sensitive(main_window, 1);
}


void
on_load_single_hash1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  load_hash_dialog = create_load_hash_dialog();
  gtk_widget_show(load_hash_dialog);
  gtk_widget_set_sensitive(main_window, 0);

}


void
on_cancel_load_hash_dialog_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(load_hash_dialog);
  gtk_widget_set_sensitive(main_window, 1);

}


void
on_ok_load_hash_dialog_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  char line[200];
  GtkWidget *tmp;

  tmp = lookup_widget(load_hash_dialog, "entry4");
  sprintf(line, "%s", gtk_entry_get_text(GTK_ENTRY(tmp)));
  if (read_line(line)) {
    fill_tree();
    tmp = lookup_widget(main_window, "launch1");
    gtk_widget_set_sensitive(tmp, 1);

    gtk_widget_destroy(load_hash_dialog);
    gtk_widget_set_sensitive(main_window, 1);
  }
  else {
    GtkWidget* error_dialog = create_dialog1();
    gtk_widget_show(error_dialog);
  }

}


void
on_load_hash_dialog_destroy            (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(load_hash_dialog);
  gtk_widget_set_sensitive(main_window, 1);

}


void
on_deletebutton_clicked                (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  GtkWidget *hash_list;
  GtkTreeIter iter;

  hash_list = lookup_widget (main_window, "hash_list");

  if (gtk_tree_selection_get_selected(gtk_tree_view_get_selection(GTK_TREE_VIEW(hash_list)),
				      NULL, &iter)) {
    remove_line(atoi(gtk_tree_model_get_string_from_iter (GTK_TREE_MODEL(list_store), &iter)));
    fill_tree();
  }
}

void
show_readahead_window(int num) {
  GtkWidget* tmp;
  char buf[50];
  gint x, y, pwidth, pheight, width, height;

  readahead_window = create_readahead_window();
  tmp = lookup_widget (readahead_window, "readahead_label");
  sprintf(buf, "Pre-loading table %d", num+1);
  gtk_label_set_text(GTK_LABEL(tmp), buf);

  gtk_window_get_position(GTK_WINDOW(main_window), &x, &y);
  gtk_window_get_size(GTK_WINDOW(main_window), &pwidth, &pheight);
  gtk_window_get_size(GTK_WINDOW(readahead_window), &width, &height);

  x = (pwidth - width) / 2 + x;
  y = (pheight - height) / 2 + y;

  gtk_widget_show(readahead_window);
  gtk_window_move(GTK_WINDOW(readahead_window), x, y);

}

void
show_clean_window(void) {
  GtkWidget* tmp;
  char buf[100];
  gint x, y, pwidth, pheight, width, height;

  readahead_window = create_readahead_window();
  tmp = lookup_widget (readahead_window, "readahead_label");
  sprintf(buf, "Trying to find place in RAM for the tables");
  gtk_label_set_text(GTK_LABEL(tmp), buf);

  gtk_window_get_position(GTK_WINDOW(main_window), &x, &y);
  gtk_window_get_size(GTK_WINDOW(main_window), &pwidth, &pheight);
  gtk_window_get_size(GTK_WINDOW(readahead_window), &width, &height);

  x = (pwidth - width) / 2 + x;
  y = (pheight - height) / 2 + y;

  gtk_widget_show(readahead_window);
  gtk_window_move(GTK_WINDOW(readahead_window), x, y);

}


void 
hide_readahead_window(void) {
  
  gtk_widget_destroy(readahead_window);

}

#ifdef LIVECD
void activate_launch_toggle (void) {

  GtkWidget *tmp;
  char tmp_file[] = "/tmp/ophcrack.tmp";

  if (read_file(tmp_file)) {
    fill_tree();
    
    gtk_widget_set_sensitive(main_window, 1);
    tmp = lookup_widget(main_window, "launch1");
    gtk_widget_set_sensitive(tmp, 1);
    tmp = lookup_widget(main_window, "save_button");
    gtk_widget_set_sensitive(tmp, 1);
    
  }
  tmp = lookup_widget(main_window, "launch1");
  gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(tmp), TRUE);

}
#endif


void
on_help_button_clicked                 (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  GtkWidget *tmp;

  gtk_widget_set_sensitive(main_window, 0);
  help_window = create_help_window();

  tmp = lookup_widget(help_window,"help_load");
  gtk_label_set_text(GTK_LABEL(tmp)," \
Use this button to load hashes into Ophcrack. You can chose from: \n \
\n \
   Single hash: to insert a single hash by hand into Ophcrack. \n \
\n \
   PWDUMP File: to import hashes from a file compatible with the \n \
                format used by pwdump.  \n \
\n \
   From Encrypted SAM: Import hashes from the SYSTEM and the SAM files \n \
                located in the System32 directory of Windows. Note \n \
                that you can only access this files from a Windows \n \
                partition that has not booted.  \n \
\n \
   From Local SAM: Loads the hashes from the SAM of Windows system \n \
                on which Ophcrack is running. You must be an\n \
                administrator of the system to be able to do this.\n \
                This is obviously only available in the Windows  \n \
                version of Ophcrack. \n \
 \n \
   From Remote SAM: Connects to a remote machine and retrieves the hashes \n \
                from the SAM. You need to know the username and password \n \
                of an administrator on the remote machine. You also need\n \
                to know the name of a writable share on the remote machine.\n \
                Only available in the Windows version of Ophcrack. \n \
\n \
");

 tmp = lookup_widget(help_window,"help_delete");
  gtk_label_set_text(GTK_LABEL(tmp)," \
This button deletes the hash that is currently selected in the \n \
main window. Use this function to remove the hashes in which  \n \
you are not interested (e.g. the Guest account). This will \n \
accelerate the cracking of the remaining hashes. \n \
");

  tmp = lookup_widget(help_window,"help_tables");
  gtk_label_set_text(GTK_LABEL(tmp)," \
This is where you select the set of rainbow tables you want to use. \n \
Following table sets are suported by this version of Ophcrack:\n \
\n \
   LM: Alphanumeric SSTIC04-10k: This is a small table set (388MB)\n \
                which contains the LanManager hashes of 99.9% of all \n \
                alphanumerical passwords. These are passwords made of \n \
                mixed case letters and numbers (about 80 billion\n \
                hashes). Because the LanManger hash cuts passwords\n \
                into two pieces of 7 characters, passwords of length\n \
                1 to 14 can be cracked with this table set. Since the\n \
                LanManager hash is also not case sensitive, the 80 \n \
                billion hashes in this table set corresponds to \n \
                12 septillion (or 2^83) passwords. \n \
\n \
   LM: Alphanumeric SSTIC04-5k: This table set also covers 99.9% of \n \
                the LanManager hashes of all alphanumerical passwords\n \
                Because the tables are about twice as big (720MB) \n \
                cracking is about four times faster, but only if  \n \
                you have at least one GB of RAM.\n \
\n \
   LM: Extended (alphanum + 33 special): This set covers 96% of \n \
                the LanManger hashes of passwords made of up to 14 \n \
                mixed case letters, numbers and the following 33 \n \
                special characters: !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|} ~\n \
                There are about 7 trillion hashes in this table set\n \
                covering 5 octillion (or 2^92) passwords\n \
\n \
   NT: (6 ext, 7 alphanum, 8 lowalpha-num): This set contains NT hahses\n \
                You can use this table set to crack the hashes on \n \
                machines where the LanManager hash has been disabled.\n \
                The set contains 99.0% of the hashes of the passwords \n \
                made of the following characters: \n \
                - up to six mixed case letters, numbers and 33 special\n \
                  characters (same as above)  \n \
                - seven mixed case letters and numbers \n \
                - eight lowercase letters and numbers\n\n \
                There are 7 trillion hashes in this table, corresponding\n \
                to 7 trillion passwords (the NT hash does not suffer from\n \
                the weaknesses of the LanManager). \n \
\n \
For most efficient cracking, start by deleting the hashes you do not \n \
want to crack. Then select an alphanumerical table set. Either the smaller\n \
one if you have 500MB or less of RAM or the larger one otherwise. Use the \n \
LM extented table set to crack the remaining hashes. If all LanManager \n \
hashes come up empty, the administrator has disabled them. Your only \n \
option is to use the NT table set. \n \
\n \
Note: the alphanumerical table sets are free and can be downloaded from \n \
the Internet. The other table sets can be ordered at \n \
http://www.objectif-securite.ch/ophcrack\n \
");

 tmp = lookup_widget(help_window,"help_launch");
  gtk_label_set_text(GTK_LABEL(tmp)," \
The launch button starts the cracking process. Don't forget to select a\n \
table set before launching the attack. Once the cracking process is \n \
started, the button transforms into a stop button. \n \
\n \
If you stop and restart a cracking session the hashes that have already\n \
been cracked will not be cracked a second time. However, the look-up \n \
process for the remaining hashes will start again at the beginning of\n \
the first table. \n \
\n \
Ophcrack will preload parts of the tables into memory depending on their\n \
size and on the amount of available RAM. The more tables it can fit \n \
into the RAM, the faster will be the attack. Under Windows you \n \
may want to quit other applications before launching the attack, to leave \n \
more memory available to Ophcrack. \n \
\n \
There are four tables in each table set. Ophcrack will cylce throuhg\n \
all four tables (one by one, two by two or more depending on available \n \
memory until it finds all hashes or arrives at the end of the last table. \n \
The status bar at the bottom of the window displays which tables are \n \
currently used and how far the look-up is in these tables. \n \
");

 tmp = lookup_widget(help_window,"help_save");
  gtk_label_set_text(GTK_LABEL(tmp)," \
Use the save button to save the current cracking session. The hases and \n \
the passwords that have already been cracked will be saved in a file\n \
in a format compatible with PWDUMP. You can later load the file using the\n \
\"PWDUMP File\" option of the Load button. \n\
");

  gtk_widget_show(help_window);
}


void
on_help_window_close                   (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(help_window);
  gtk_widget_set_sensitive(main_window, 1);
}

void show_dialog(char *title, char *body) {
  GtkWidget *tmp;

  GtkWidget* error_dialog = create_dialog1();
  gtk_window_set_title (GTK_WINDOW (error_dialog), title);
  tmp = lookup_widget(error_dialog, "label3");
  gtk_label_set_text(GTK_LABEL(tmp), body);
  gtk_widget_show(error_dialog);

}

