# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:095 (ghostscript)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63873);
 script_cve_id("CVE-2007-6725", "CVE-2008-6679", "CVE-2009-0583", "CVE-2009-0584", "CVE-2009-0792", "CVE-2009-0196");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Mandrake Security Advisory MDVSA-2009:095 (ghostscript)";
 script_name(name);

 desc = "The remote host is missing an update to ghostscript
announced via advisory MDVSA-2009:095.

A buffer underflow in Ghostscript's CCITTFax decoding filter allows
remote attackers to cause denial of service and possibly to execute
arbitrary by using a crafted PDF file (CVE-2007-6725).

Buffer overflow in Ghostscript's BaseFont writer module allows
remote attackers to cause a denial of service and possibly to execute
arbitrary code via a crafted Postscript file (CVE-2008-6679).

Multiple interger overflows in Ghostsript's International Color
Consortium Format Library (icclib) allows attackers to cause denial
of service (heap-based buffer overflow and application crash) and
possibly execute arbirary code by using either a PostScript or PDF
file with crafte embedded images (CVE-2009-0583, CVE-2009-0584).

Multiple interger overflows in Ghostsript's International Color
Consortium Format Library (icclib) allows attackers to cause denial
of service (heap-based buffer overflow and application crash) and
possibly execute arbirary code by using either a PostScript or PDF
file with crafte embedded images. Note: this issue exists because of
an incomplete fix for CVE-2009-0583 (CVE-2009-0792).

Heap-based overflow in Ghostscript's JBIG2 decoding library allows
attackers to cause denial of service and possibly to execute arbitrary
code by using a crafted PDF file (CVE-2009-0196).

This update provides fixes for that vulnerabilities.

Update:

gostscript packages from Mandriva Linux 2009.0 distribution are not
affected by CVE-2007-6725.

Affected: 2008.1, 2009.0, Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:095

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:095 (ghostscript)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-common", rpm:"ghostscript-common~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-doc", rpm:"ghostscript-doc~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-dvipdf", rpm:"ghostscript-dvipdf~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-module-X", rpm:"ghostscript-module-X~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-X", rpm:"ghostscript-X~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgs8", rpm:"libgs8~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgs8-devel", rpm:"libgs8-devel~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libijs1", rpm:"libijs1~0.35~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libijs1-devel", rpm:"libijs1-devel~0.35~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gs8", rpm:"lib64gs8~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gs8-devel", rpm:"lib64gs8-devel~8.61~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ijs1", rpm:"lib64ijs1~0.35~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ijs1-devel", rpm:"lib64ijs1-devel~0.35~60.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-common", rpm:"ghostscript-common~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-doc", rpm:"ghostscript-doc~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-dvipdf", rpm:"ghostscript-dvipdf~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-module-X", rpm:"ghostscript-module-X~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-X", rpm:"ghostscript-X~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgs8", rpm:"libgs8~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgs8-devel", rpm:"libgs8-devel~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libijs1", rpm:"libijs1~0.35~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libijs1-devel", rpm:"libijs1-devel~0.35~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gs8", rpm:"lib64gs8~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gs8-devel", rpm:"lib64gs8-devel~8.63~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ijs1", rpm:"lib64ijs1~0.35~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ijs1-devel", rpm:"lib64ijs1-devel~0.35~62.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-common", rpm:"ghostscript-common~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-dvipdf", rpm:"ghostscript-dvipdf~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-module-X", rpm:"ghostscript-module-X~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-X", rpm:"ghostscript-X~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgs8", rpm:"libgs8~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgs8-devel", rpm:"libgs8-devel~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libijs1", rpm:"libijs1~0.35~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libijs1-devel", rpm:"libijs1-devel~0.35~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gs8", rpm:"lib64gs8~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gs8-devel", rpm:"lib64gs8-devel~8.15~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ijs1", rpm:"lib64ijs1~0.35~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ijs1-devel", rpm:"lib64ijs1-devel~0.35~46.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
