###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_wsftp_win_detect.nasl 1083 2009-03-09 17:05:29Z Feb $
#
# WS_FTP Server Checking
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################
if(description)
{
  script_id(900608);
  script_version ("$Revision: 1.1 $");
  script_name(english: "WS_FTP Version Detection");
  desc["english"] = "
  Overview: This script determines the WsFtp server version on the remote host
  and sets the result in the KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets KB of WsFTP version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod.");
  script_family(english:"FTP");
  script_dependencie("find_service.nes");
  script_require_ports("Services/www", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if("WS_FTP Server" >< banner)
{
  wsVer = eregmatch(pattern:"WS_FTP Server ([0-9.]+)", string:banner);
  if(wsVer[1] != NULL){
    set_kb_item(name:"WSFTP/Win/Ver", value:wsVer[1]);
  }
}
