###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tor_detect_lin.nasl 625 2008-12-29 17:40:29Z dec $
#
# Tor Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) SecPod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900418);
  script_version("$Revision: 1.0 $");
  script_name(english:"Tor Version Detection (Linux)");
  desc["english"] = "

  Overview: The script detects the version of Tor on remote host and
  sets the KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Check for Tor version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

torName = find_file(file_name:"tor", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);
foreach binaryName (torName)
{
  binaryName = chomp(binaryName);
  torVer = get_bin_version(full_prog_name:binaryName, version_argv:"--version",
                              ver_pattern:"Tor v([0-9.]+)", sock:sock);
  if(torVer[1] != NULL)
  {
    set_kb_item(name:"Tor/Linux/Ver", value:torVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
