###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openoffice_dos_vuln_win.nasl 893 2009-01-29 10:45:56 jan $
#
# OpenOffice Denial of Service Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900077);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0259");
  script_bugtraq_id(33383);
  script_name(english:"OpenOffice Denial of Service Vulnerability (Win)");
  desc["english"] = "

  Overview: The host has OpenOffice installed and is prone to denial of service
  vulnerability.

  Vulnerability Insight:
  OpenOffice application could trigger memory corruption due to a maliciously
  crafted .doc, .wri, or .rtf word 97 files.

  Impact:
  Successful remote exploitation could result in arbitrary code execution on
  the affected system which leads to application crash.

  Impact Level: Application

  Affected Software/OS:
  OpenOffice 1.1.2 to 1.1.5 on Windows.

  Fix: Upgrade to OpenOffice latest version,
  http://www.openoffice.org/ 

  References:
  http://www.milw0rm.com/exploits/6560
  http://www.openwall.com/lists/oss-security/2009/01/21/9

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_openoffice_detect_win.nasl");
  script_require_keys("OpenOffice/Win/Ver");
  exit(0);
}


include("version_func.inc");

openVer = get_kb_item("OpenOffice/Win/Ver");
if(!openVer){
  exit(0);
}

if(version_in_range(version:openVer, test_version:"1.1.2",
                                     test_version2:"1.1.5")){
  security_hole(0);
}
