###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_eset_remote_administrator_detect.nasl 1028 2009-02-24 16:14:79Z feb $
#
# ESET Remote Administrator Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900508);
  script_version("Revision: 1.0 $");
  script_name(english:"ESET Remote Administrator Version Detection");
  desc["english"] = "

  Overview: This script detects the installed version of ESET Remote
  Administrator and saves the version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_family(english:"General");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod ");
  script_summary(english:"Set Version of ESET Remote Administrator in KB");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(registry_key_exists(key:"SOFTWARE\ESET\ESET Remote Administrator\Console"))
{
  consoleVer = registry_get_sz(key:"SOFTWARE\ESET\ESET Remote Administrator" +
                                   "\Console\CurrentVersion\Info",
                               item:"ProductVersion");
  if(consoleVer != NULL){
    set_kb_item(name:"ESET/RemoteAdmin/Console/Ver", value:consoleVer);
  }
}

if(registry_key_exists(key:"SOFTWARE\ESET\ESET Remote Administrator\Server"))
{
  servVer = registry_get_sz(key:"SOFTWARE\ESET\ESET Remote Administrator" +
                                "\Server\CurrentVersion\Info",
                            item:"ProductVersion");
  if(servVer != NULL){
    set_kb_item(name:"ESET/RemoteAdmin/Server/Ver", value:servVer);
  }
}
