# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:020 (xine-lib)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63252);
 script_cve_id("CVE-2008-3231", "CVE-2008-5233", "CVE-2008-5234", "CVE-2008-5236", "CVE-2008-5237", "CVE-2008-5239", "CVE-2008-5240", "CVE-2008-5241", "CVE-2008-5243", "CVE-2008-5245", "CVE-2008-5246");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:020 (xine-lib)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xine-lib
announced via advisory MDVSA-2009:020.

For details, please visit the referenced security advisories.

This update provides the fix for all these security issues found in
xine-lib 1.1.11 of Mandriva 2008.1. The vulnerabilities: CVE-2008-5234,
CVE-2008-5236, CVE-2008-5237, CVE-2008-5239, CVE-2008-5240,
CVE-2008-5243 are found in xine-lib 1.1.15 of Mandriva 2009.0 and
are also fixed by this update.

Affected: 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:020

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:020 (xine-lib)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libxine1", rpm:"libxine1~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine-devel", rpm:"libxine-devel~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-aa", rpm:"xine-aa~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-caca", rpm:"xine-caca~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-dxr3", rpm:"xine-dxr3~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-esd", rpm:"xine-esd~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-flac", rpm:"xine-flac~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-gnomevfs", rpm:"xine-gnomevfs~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-image", rpm:"xine-image~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-jack", rpm:"xine-jack~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-plugins", rpm:"xine-plugins~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-pulse", rpm:"xine-pulse~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-sdl", rpm:"xine-sdl~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-smb", rpm:"xine-smb~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-wavpack", rpm:"xine-wavpack~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64xine1", rpm:"lib64xine1~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64xine-devel", rpm:"lib64xine-devel~1.1.11.1~4.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine1", rpm:"libxine1~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxine-devel", rpm:"libxine-devel~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-aa", rpm:"xine-aa~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-caca", rpm:"xine-caca~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-dxr3", rpm:"xine-dxr3~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-esd", rpm:"xine-esd~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-flac", rpm:"xine-flac~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-gnomevfs", rpm:"xine-gnomevfs~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-image", rpm:"xine-image~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-jack", rpm:"xine-jack~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-plugins", rpm:"xine-plugins~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-pulse", rpm:"xine-pulse~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-sdl", rpm:"xine-sdl~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-smb", rpm:"xine-smb~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-wavpack", rpm:"xine-wavpack~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64xine1", rpm:"lib64xine1~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64xine-devel", rpm:"lib64xine-devel~1.1.15~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
