###############################################################################
# OpenVAS Vulnerability Test
# $Id:$
#
# Jetty Cross Site Scripting and Information Disclosure
# Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100183);
 script_bugtraq_id(34800);
 script_version ("1.0");

 script_name(english:"Jetty Cross Site Scripting and Information Disclosure Vulnerabilities");
 desc["english"] = "

 Overview:
  Jetty is prone to a cross-site scripting vulnerability and an
  information-disclosure vulnerability.

  An attacker may leverage these issues to execute arbitrary script
  code in the browser of an unsuspecting user in the context of the
  affected site, steal cookie-based authentication credentials, and
  obtain sensitive information.

  Jetty 6.1.16 and prior versions are affected. 

 Solution:
  The vendor has released an update. See http://jetty.mortbay.org/jetty/index.html
  for more information.

 See also:
  http://www.securityfocus.com/bid/34800

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Jetty is vulnerable to XSS and Information Disclosure");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web Servers");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("misc_func.inc");
include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)) exit(0);
if(get_kb_item("Services/www/" + port + "/embedded" ))exit(0);

banner = get_http_banner(port:port);
if (!banner)exit(0);
if(!egrep(pattern:"Server: Jetty", string:banner) ) exit(0);

version = eregmatch(pattern: "Server: Jetty\(([0-9.]+[pre0-9]*)\)", string: banner);

if(!isnull(version[1])) {
  if(version_is_less_equal(version: version[1], test_version: "6.1.16")) {
   security_warning(port:port);
   exit(0);
 }
}  

exit(0);
