###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wordpressmu_mult_xss_vuln.nasl 365 2008-11-4 11:47:09Z oct $
#
# WordPress MU Multiple XSS Vulnerabilities - Oct08
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800125);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4671");
  script_bugtraq_id(31482);
  script_name(english:"WordPress MU Multiple XSS Vulnerabilities - Oct08");
  desc["english"] = "

  Overview: The host is running WordPress MU, which is prone to Multiple
  XSS Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to the 's' and 'ip_address' parameters in
  wp-admin/wp-blogs.php which is not properly sanitized before being returned
  to the user.

  Impact: Successful attack could lead to execution of arbitrary HTML and
  script code in the context of an affected site and attackers can steal
  cookie-based authentication credentials.

  Impact Level: Application

  Affected Software/OS:
  WordPress MU before 2.6 on all running platform.

  Fix: Update to Version 2.6 or later.
  http://wordpress.org/

  References:
  http://secunia.com/advisories/32060
  http://www.juniper.fi/security/auto/vulnerabilities/vuln28845.html

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of WordPress MU");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"CGI abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

dirs = make_list("/wordpress-mu", cgi_dirs());
foreach dir (dirs)
{
  url = dir + "/index.php";
  sndReq = http_get(item:url, port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"WordPress Mu", string:rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    wdPressVer = eregmatch(pattern:"WordPress ([0-9.]+)", string:rcvRes);
    if(wdPressVer != NULL)
    {
      if(version_is_less(version:wdPressVer[1], test_version:"2.6")){
        security_warning(port);
      }
    }
    exit(0);
  }
}
