###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_winftp_serv_bof_vuln.nasl 928 2009-02-03 13:21:29Z feb $
#
# WinFTP Server LIST Command Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800346);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0351");
  script_bugtraq_id(33454);
  script_name(english:"WinFTP Server LIST Command Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is running WinFTP Server and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  The flaw exists when processing malformed arguments passed to the LIST command
  with an asterisk (*) character.

  Impact:
  Allows remote authenticated attackers to execute arbitrary code within the
  context of the affected application resulting in buffer overflow and can cause
  denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  WinFTP Server version 2.3.0 and prior on Windows.

  Fix: No solution or patch is available as on 04th February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.wftpserver.com/

  References:
  http://www.milw0rm.com/exploits/7875
  http://xforce.iss.net/xforce/xfdb/48263

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 8.1
  Risk factor: Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of WinFTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_winftp_serv_detect.nasl");
  script_require_keys("WinFTP/Server/Ver");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  exit(0);
}

winFtpVer = get_kb_item("WinFTP/Server/Ver");
if(!winFtpVer){
  exit(0);
}

# Check for version 2.3.0.0 and prior
if(version_is_less_equal(version:winFtpVer, test_version:"2.3.0.0")){
  security_hole(ftpPort);
}
