###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_twiki_xss_n_cmd_exec_vuln.nasl 640 2008-12-13 15:32:17Z dec $
#
# TWiki XSS and Command Execution Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800320);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5304", "CVE-2008-5305");
  script_bugtraq_id(32668, 32669);
  script_name(english:"TWiki XSS and Command Execution Vulnerabilities");
  desc["english"] = "

  Overview: The host is running TWiki and is prone to Cross-Site Scripting
  (XSS) and Command Execution Vulnerabilities.

  Vulnerability Insight:
  The flaw are caused due to,
  - %URLPARAM{}% variable is not properly sanitized which lets attackers
    conduct cross-site scripting attack.
  - %SEARCH{}% variable is not properly sanitised before being used in an
    eval() call which lets the attackers execute perl code through eval
    injection attack.

  Impact:
  Successful exploitation could allow execution of arbitrary script code or
  commands. This could let attackers steal cookie-based authentication
  credentials or compromise the affected application.

  Impact Level: Application

  Affected Software/OS:
  TWiki, TWiki version prior to 4.2.4.

  Fix: Upgrade to version 4.2.4 or later,
  http://twiki.org/cgi-bin/view/Codev/TWikiRelease04x02x04

  References:
  http://twiki.org/cgi-bin/view/Codev.SecurityAlert-CVE-2008-5304
  http://twiki.org/cgi-bin/view/Codev/SecurityAlert-CVE-2008-5305

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of TWiki");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach path (make_list("/twiki", cgi_dirs()))
{
  soc = http_open_socket(port);
  if(!soc){
    exit(0);
  }

  sndReq = http_get(item:path + "/bin/view/TWiki/WebHome", port:port);
  send(socket:soc, data:sndReq);
  rcvRes = http_recv(socket:soc);
  http_close_socket(soc);

  if(!rcvRes){
    exit(0);
  }

  if(rcvRes =~ "Powered by TWiki")
  {
    twikiVer = eregmatch(pattern:"TWiki-([0-9.]+),", string:rcvRes);
    if(twikiVer[1] != NULL)
    {
      if(version_is_less(version:twikiVer[1], test_version:"4.2.4")){
        security_hole(port);
      }
    }
    exit(0);
  }
}
