###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for net-snmp SUSE-SA:2008:039
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850042);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-039");
  script_cve_id("CVE-2008-0960", "CVE-2008-2292", "CVE-2008-1290", "CVE-2008-1291", "CVE-2008-1292");
  script_name(english: "SuSE Update for net-snmp SUSE-SA:2008:039");
  desc["english"] = "

  Vulnerability Insight:

  The net-snmp daemon implements the &quot;simple network management protocol&quot;.
  The version 3 of SNMP as implemented in net-snmp uses the length of the
  HMAC in a packet to verify against a local HMAC for authentication.
  An attacker can therefore send a SNMPv3 packet with a one byte HMAC and
  guess the correct first byte of the local HMAC with 256 packets (max).

  Additionally a buffer overflow in perl-snmp was fixed that can cause a
  denial-of-service/crash.

  Impact:
  authentication bypass, denial-of-service

  Affected Software/OS:
  net-snmp on openSUSE 10.2, openSUSE 10.3, openSUSE 11.0, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SLE SDK 10 SP2, SUSE Linux Enterprise Server 10 SP1, SUSE Linux Enterprise Desktop 10 SP2, SUSE Linux Enterprise Server 10 SP2

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_39_snmp.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of net-snmp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"libsnmp15", rpm:"libsnmp15~5.4.1~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.4.1~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.4.1~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.4.1~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snmp-mibs", rpm:"snmp-mibs~5.4.1~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.4.1~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.4.rc2~8", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.4.rc2~8", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.4.rc2~8", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.4.rc2~8", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP2")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP2")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE11.0")
{

  if(isrpmvuln(pkg:"libsnmp15", rpm:"libsnmp15~5.4.1~77.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.4.1~77.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.4.1~77.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.4.1~77.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snmp-mibs", rpm:"snmp-mibs~5.4.1~77.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.4.1~77.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP2")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.26", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.26", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.26", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.26", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.0.1~25.24.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.3.0.1~25.24.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.3.0.1~25.24.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-32bit", rpm:"net-snmp-32bit~5.3.0.1~25.24.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.1.3.1~0.22", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.1.3.1~0.22", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.1.3.1~0.22", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}