###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for samba SUSE-SA:2007:031
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850111);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-031");
  script_cve_id("CVE-2007-2444", "CVE-2007-2446", "CVE-2007-2447");
  script_name(english: "SuSE Update for samba SUSE-SA:2007:031");
  desc["english"] = "

  Vulnerability Insight:

  The Samba server was affected by several security problems which have
  been fixed.

  Following security problems were fixed:

  CVE-2007-2446: Specially crafted MS-RPC packets could overwrite heap
  memory and therefore could potentially be exploited to execute code.

  CVE-2007-2447: Authenticated users could leverage specially crafted
  MS-RPC packets to pass arguments unfiltered to /bin/sh.

  CVE-2007-2444: A bug in the local SID/Name translation routines
  may potentially result in a user being able to issue SMB protocol
  operations as root.

  Updates were released over the last few days as follows:

  - SUSE Linux Enterprise 10, SUSE Linux 10.0, 10.1 and openSUSE 10.2
  updates were released last Tuesday (May 15th)
  - SUSE Linux Enterprise Server 8 and SUSE Linux Desktop 1.0 packages
  were released last Wednesday (May 16th)
  - SUSE Linux Enterprise Server 9 and Novell Linux Desktop 9 packages
  were released yesterday (May 21st)

  Impact:
  remote code execution

  Affected Software/OS:
  samba on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE SLED 10, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_31_samba.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"libmsrpc", rpm:"libmsrpc~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmsrpc-devel", rpm:"libmsrpc-devel~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-python", rpm:"samba-python~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-32bit", rpm:"libsmbclient-32bit~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-32bit", rpm:"samba-32bit~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client-32bit", rpm:"samba-client-32bit~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind-32bit", rpm:"samba-winbind-32bit~3.0.23d~19.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.22~13.30", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-32bit", rpm:"samba-32bit~3.0.22~13.30", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.22~13.30", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client-32bit", rpm:"samba-client-32bit~3.0.22~13.30", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.22~13.30", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind-32bit", rpm:"samba-winbind-32bit~3.0.22~13.30", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~2.2.8a~241", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~2.2.8a~241", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan", rpm:"samba-vscan~0.3.2a~293", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-pdb", rpm:"samba-pdb~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-python", rpm:"samba-python~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan", rpm:"samba-vscan~0.3.6b~0.21", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.20b~3.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-pdb", rpm:"samba-pdb~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-python", rpm:"samba-python~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan", rpm:"samba-vscan~0.3.6b~0.21", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.20b~3.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-pdb", rpm:"samba-pdb~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-python", rpm:"samba-python~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan", rpm:"samba-vscan~0.3.6b~0.21", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.20b~3.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-pdb", rpm:"samba-pdb~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-python", rpm:"samba-python~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan", rpm:"samba-vscan~0.3.6b~0.21", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.20b~3.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.22~13.30", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.22~13.30", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.22~13.30", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLED10")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.22~13.30", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-32bit", rpm:"samba-32bit~3.0.22~13.30", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.22~13.30", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client-32bit", rpm:"samba-client-32bit~3.0.22~13.30", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.22~13.30", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind-32bit", rpm:"samba-winbind-32bit~3.0.22~13.30", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}