###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for w3m SUSE-SA:2007:005
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850065);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-005");
  script_cve_id("CVE-2006-6772");
  script_name(english: "SuSE Update for w3m SUSE-SA:2007:005");
  desc["english"] = "

  Vulnerability Insight:

  A format string problem in w3m -dump / -backend mode could be used
  by a malicious server to crash w3m or execute code.

  In SUSE Linux 10.1, openSUSE 10.2 and SUSE Linux Enterprise Server
  and Desktop 10 this problem was not exploitable to execute code due
  to use of the FORTIFY SOURCE extensions.

  This problem is tracked by the Mitre CVE ID CVE-2006-6772.

  Impact:
  remote denial of service, remote code execution

  Affected Software/OS:
  w3m on Novell Linux Desktop 9, Novell Linux POS 9, Open Enterprise Server, openSUSE 10.2, SUSE LINUX 10.1, SuSE Linux Enterprise Server 8, SUSE SLED 10, SUSE SLES 10, SUSE SLES 9

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_05_w3m.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of w3m");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~41.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.4.1_m17n_20030308~201.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.3.1~205", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.4.1_m17n_20030308~201.3", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.3.1~205", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.4.1_m17n_20030308~201.3", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.3.1~205", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.4.1_m17n_20030308~201.3", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.3.1~205", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.4.1_m17n_20030308~201.3", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.3.1~205", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.4.1_m17n_20030308~201.3", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.3.1~205", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLED10")
{

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.4.1_m17n_20030308~201.3", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.3.1~205", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"w3m", rpm:"w3m~0.5.1~19.5", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}