###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_rtl_allocateMemory_bof_vuln_win.nasl 0295 2008-10-01 10:23:16Z oct $
#
# OpenOffice rtl_allocateMemory Heap Based BOF Vulnerability
#
# Authors:      Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800009);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-2152");
  script_bugtraq_id(29622);
  script_xref(name:"CB-A", value:"08-0095");
  script_name(english:"OpenOffice rtl_allocateMemory Heap Based BOF Vulnerability");
  desc["english"] = "

  Overview: The host has OpenOffice installed which is prone to heap based
  buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw is in alloc_global.c file in which rtl_allocateMemory function
  rounding up allocation requests to be aligned on a 8 byte boundary without
  checking the rounding results, in an integer overflow condition.

  Impact:
  Exploitation will result in buffer overflows via a specially crafted document
  and allow remote unprivileged user who provides a OpenOffice.org document that
  is opened by a local user to execute arbitrary commands on the system with the
  privileges of the user running OpenOffice.org.

  Impact Level: System

  Affected Software/OS:
  OpenOffice.org 2.x on Windows (Any).

  Fix : Upgrade to OpenOffice 2.4.1
  http://download.openoffice.org/index.html

  References:
  http://secunia.com/advisories/30599
  http://www.openoffice.org/security/cves/CVE-2008-2152.html
  http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=714

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
keys = registry_enum_keys(key);
foreach item (keys)
{
  if("OpenOffice.org" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    if((egrep(pattern:"^([01]\..*|2\.([0-3](\..*)?|4(\.([0-8]?[0-9]?" +
                      "[0-9]?[0-9]|9[0-2][0-9][0-9]|930[0-9]))?))$",
              string:registry_get_sz(key:key + item, item:"DisplayVersion")))){
      security_hole(0);
    }
    exit(0);
  }
}
