###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for cups MDVSA-2008:211 (cups)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830644);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:211");
  script_cve_id("CVE-2008-3639", "CVE-2008-3640", "CVE-2008-3641");
  script_name(english: "Mandriva Update for cups MDVSA-2008:211 (cups)");
  desc["english"] = "

  Vulnerability Insight:

  A buffer overflow in the SGI image format decoding routines used by the
  CUPS image converting filter imagetops was discovered.  An attacker
  could create malicious SGI image files that could possibly execute
  arbitrary code if the file was printed (CVE-2008-3639).
  
  An integer overflow flaw leading to a heap buffer overflow was found
  in the Text-to-PostScript texttops filter.  An attacker could create
  a malicious text file that could possibly execute arbitrary code if
  the file was printed (CVE-2008-3640).
  
  Finally, an insufficient buffer bounds checking flaw was found in
  the HP-GL/2-to-PostScript hpgltops filter.  An attacker could create
  a malicious HP-GL/2 file that could possibly execute arbitrary code
  if the file was printed (CVE-2008-3641).
  
  The updated packages have been patched to prevent this issue; for
  Mandriva Linux 2009.0 the latest CUPS version (1.3.9) is provided
  that corrects these issues and also provides other bug fixes.

  Affected Software/OS:
  cups on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00017.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cups");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-common", rpm:"cups-common~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-serial", rpm:"cups-serial~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2", rpm:"libcups2~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2-devel", rpm:"libcups2-devel~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cups", rpm:"php-cups~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2", rpm:"lib64cups2~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2-devel", rpm:"lib64cups2-devel~1.2.10~2.8mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-common", rpm:"cups-common~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-serial", rpm:"cups-serial~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2", rpm:"libcups2~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2-devel", rpm:"libcups2-devel~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cups", rpm:"php-cups~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2", rpm:"lib64cups2~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2-devel", rpm:"lib64cups2-devel~1.3.6~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-common", rpm:"cups-common~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-serial", rpm:"cups-serial~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2", rpm:"libcups2~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2-devel", rpm:"libcups2-devel~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cups", rpm:"php-cups~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2", rpm:"lib64cups2~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2-devel", rpm:"lib64cups2-devel~1.3.6~5.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-common", rpm:"cups-common~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-serial", rpm:"cups-serial~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2", rpm:"libcups2~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2-devel", rpm:"libcups2-devel~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cups", rpm:"php-cups~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2", rpm:"lib64cups2~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2-devel", rpm:"lib64cups2-devel~1.3.9~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}