###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for openldap MDVSA-2008:058 (openldap)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830658);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:058");
  script_cve_id("CVE-2007-5708", "CVE-2007-6698", "CVE-2008-0658");
  script_name(english: "Mandriva Update for openldap MDVSA-2008:058 (openldap)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability was found in slapo-pcache in slapd of OpenLDAP prior
  to 2.3.39 when running as a proxy-caching server.  It would allocate
  memory using a malloc variant rather than calloc, which prevented
  an array from being properly initialized and could possibly allow
  attackers to cause a denial of service (CVE-2007-5708).
  
  Two vulnerabilities were found in how slapd handled modify (prior
  to 2.3.26) and modrdn (prior to 2.3.29) requests with NOOP control
  on objects stored in the BDB backend.  An authenticated user with
  permission to perform modify (CVE-2007-6698) or modrdn (CVE-2008-0658)
  operations could cause slapd to crash.
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  openldap on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-03/msg00003.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openldap");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libldap2.3_0", rpm:"libldap2.3_0~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libldap2.3_0-devel", rpm:"libldap2.3_0-devel~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libldap2.3_0-static-devel", rpm:"libldap2.3_0-static-devel~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap", rpm:"openldap~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-clients", rpm:"openldap-clients~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-doc", rpm:"openldap-doc~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers", rpm:"openldap-servers~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-testprogs", rpm:"openldap-testprogs~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-tests", rpm:"openldap-tests~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0", rpm:"lib64ldap2.3_0~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0-devel", rpm:"lib64ldap2.3_0-devel~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0-static-devel", rpm:"lib64ldap2.3_0-static-devel~2.3.34~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libldap2.3_0", rpm:"libldap2.3_0~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libldap2.3_0-devel", rpm:"libldap2.3_0-devel~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libldap2.3_0-static-devel", rpm:"libldap2.3_0-static-devel~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap", rpm:"openldap~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-clients", rpm:"openldap-clients~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-doc", rpm:"openldap-doc~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers", rpm:"openldap-servers~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0", rpm:"lib64ldap2.3_0~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0-devel", rpm:"lib64ldap2.3_0-devel~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0-static-devel", rpm:"lib64ldap2.3_0-static-devel~2.3.27~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libldap2.3_0", rpm:"libldap2.3_0~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libldap2.3_0-devel", rpm:"libldap2.3_0-devel~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libldap2.3_0-static-devel", rpm:"libldap2.3_0-static-devel~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap", rpm:"openldap~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-clients", rpm:"openldap-clients~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-doc", rpm:"openldap-doc~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-servers", rpm:"openldap-servers~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-testprogs", rpm:"openldap-testprogs~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openldap-tests", rpm:"openldap-tests~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0", rpm:"lib64ldap2.3_0~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0-devel", rpm:"lib64ldap2.3_0-devel~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ldap2.3_0-static-devel", rpm:"lib64ldap2.3_0-static-devel~2.3.38~3.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}