###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for isdn4k-utils MDVA-2008:014 (isdn4k-utils)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830366);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:014");
  script_cve_id("");
  script_name(english: "Mandriva Update for isdn4k-utils MDVA-2008:014 (isdn4k-utils)");
  desc["english"] = "

  Vulnerability Insight:

  The capi4linux initscript from the isdn4k-utils package in Mandriva
  Linux 2008.0 had incorrect permissions, which prevented it from
  being used.
  
  The updated package fixes the permissions of the initscript.

  Affected Software/OS:
  isdn4k-utils on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00036.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of isdn4k-utils");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"isdn4k-utils", rpm:"isdn4k-utils~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"isdn4k-utils-doc", rpm:"isdn4k-utils-doc~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"isdn4k-utils-eurofile", rpm:"isdn4k-utils-eurofile~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"isdn4k-utils-isdnlog", rpm:"isdn4k-utils-isdnlog~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"isdn4k-utils-vbox", rpm:"isdn4k-utils-vbox~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"isdn4k-utils-xtools", rpm:"isdn4k-utils-xtools~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libisdn4k-utils2", rpm:"libisdn4k-utils2~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libisdn4k-utils2-devel", rpm:"libisdn4k-utils2-devel~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64isdn4k-utils2", rpm:"lib64isdn4k-utils2~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64isdn4k-utils2-devel", rpm:"lib64isdn4k-utils2-devel~3.2p3~30.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}