###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libvorbis MDKSA-2007:167 (libvorbis)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830314);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:167");
  script_cve_id("CVE-2007-3106", "CVE-2007-4029");
  script_name(english: "Mandriva Update for libvorbis MDKSA-2007:167 (libvorbis)");
  desc["english"] = "

  Vulnerability Insight:

  David Thiel discovered that libvorbis did not correctly verify the size
  of certain headers, and did not correctly clean up a broken stream.
  If a user were tricked into processing a specially crafted Vorbis
  stream, a remote attacker could possibly cause a denial of service
  or execute arbitrary code with the user's privileges.

  Affected Software/OS:
  libvorbis on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-08/msg00011.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libvorbis");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libvorbis0", rpm:"libvorbis0~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbis0-devel", rpm:"libvorbis0-devel~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbisenc2", rpm:"libvorbisenc2~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbisfile3", rpm:"libvorbisfile3~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbis", rpm:"libvorbis~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbis0", rpm:"lib64vorbis0~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbis0-devel", rpm:"lib64vorbis0-devel~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbisenc2", rpm:"lib64vorbisenc2~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbisfile3", rpm:"lib64vorbisfile3~1.1.2~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libvorbis0", rpm:"libvorbis0~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbis0-devel", rpm:"libvorbis0-devel~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbisenc2", rpm:"libvorbisenc2~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbisfile3", rpm:"libvorbisfile3~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvorbis", rpm:"libvorbis~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbis0", rpm:"lib64vorbis0~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbis0-devel", rpm:"lib64vorbis0-devel~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbisenc2", rpm:"lib64vorbisenc2~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64vorbisfile3", rpm:"lib64vorbisfile3~1.1.2~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}