###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for MySQL MDKSA-2007:139 (MySQL)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830063);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:139");
  script_cve_id("CVE-2007-1420", "CVE-2007-2583", "CVE-2007-2691");
  script_name(english: "Mandriva Update for MySQL MDKSA-2007:139 (MySQL)");
  desc["english"] = "

  Vulnerability Insight:

  MySQL 5.x before 5.0.36 allows local users to cause a denial of service
  (database crash) by performing information_schema table subselects
  and using ORDER BY to sort a single-row result, which prevents
  certain structure elements from being initialized and triggers a
  NULL dereference in the filesort function. This issue does not affect
  MySQL 5.0.37 in Mandriva Linux 2007.1. (CVE-2007-1420)
  
  The in_decimal::set function in item_cmpfunc.cc in MySQL before 5.0.40,
  and 5.1 before 5.1.18-beta, allows context-dependent attackers to cause
  a denial of service (crash) via a crafted IF clause that results in
  a divide-by-zero error and a NULL pointer dereference. (CVE-2007-2583)
  
  MySQL before 4.1.23, 5.0.x before 5.0.42, and 5.1.x before 5.1.18
  does not require the DROP privilege for RENAME TABLE statements,
  which allows remote authenticated users to rename arbitrary
  tables. (CVE-2007-2691)
  
  Updated packages have been patched to prevent the above issues.

  Affected Software/OS:
  MySQL on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-07/msg00003.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of MySQL");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"MySQL", rpm:"MySQL~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-Max", rpm:"MySQL-Max~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-bench", rpm:"MySQL-bench~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-client", rpm:"MySQL-client~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-common", rpm:"MySQL-common~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-extra", rpm:"MySQL-ndb-extra~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-management", rpm:"MySQL-ndb-management~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-storage", rpm:"MySQL-ndb-storage~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-tools", rpm:"MySQL-ndb-tools~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15", rpm:"libmysql15~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-devel", rpm:"libmysql15-devel~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-static-devel", rpm:"libmysql15-static-devel~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15", rpm:"lib64mysql15~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-devel", rpm:"lib64mysql15-devel~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-static-devel", rpm:"lib64mysql15-static-devel~5.0.37~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"MySQL", rpm:"MySQL~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-Max", rpm:"MySQL-Max~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-bench", rpm:"MySQL-bench~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-client", rpm:"MySQL-client~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-common", rpm:"MySQL-common~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-extra", rpm:"MySQL-ndb-extra~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-management", rpm:"MySQL-ndb-management~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-storage", rpm:"MySQL-ndb-storage~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-tools", rpm:"MySQL-ndb-tools~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15", rpm:"libmysql15~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-devel", rpm:"libmysql15-devel~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-static-devel", rpm:"libmysql15-static-devel~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15", rpm:"lib64mysql15~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-devel", rpm:"lib64mysql15-devel~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-static-devel", rpm:"lib64mysql15-static-devel~5.0.24a~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}