###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for xpdf MDKSA-2007:021 (xpdf)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830090);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:021");
  script_cve_id("CVE-2007-0104");
  script_name(english: "Mandriva Update for xpdf MDKSA-2007:021 (xpdf)");
  desc["english"] = "

  Vulnerability Insight:

  The Adobe PDF specification 1.3, as implemented by xpdf 3.0.1 patch 2,
  kpdf in KDE before 3.5.5, and other products, allows remote attackers
  to have an unknown impact, possibly including denial of service
  (infinite loop), arbitrary code execution, or memory corruption, via a
  PDF file with a (1) crafted catalog dictionary or (2) a crafted Pages
  attribute that references an invalid page tree node.
  
  The updated packages have been patched to correct this problem.

  Affected Software/OS:
  xpdf on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00031.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xpdf");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.01pl2~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.01pl2~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}