###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for rpmdrake MDKA-2007:078 (rpmdrake)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830114);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:078");
  script_cve_id("");
  script_name(english: "Mandriva Update for rpmdrake MDKA-2007:078 (rpmdrake)");
  desc["english"] = "

  Vulnerability Insight:

  The rpmdrake package erronously warned it could not install some
  packages from a DVD, due to read errors, while it did install them
  (bug #30463). This update fix this issue.
  
  Also, this update will make the install/update progress dialog to be
  closed before displaying errors or .rpmnew files.

  Affected Software/OS:
  rpmdrake on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-07/msg00005.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of rpmdrake");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"park-rpmdrake", rpm:"park-rpmdrake~3.69.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rpmdrake", rpm:"rpmdrake~3.69.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}