###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for xen RHSA-2008:0892-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870027);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0892-01");
  script_cve_id("CVE-2008-1945", "CVE-2008-1952");
  script_name(english: "RedHat Update for xen RHSA-2008:0892-01");
  desc["english"] = "

  Vulnerability Insight:
  The xen packages contain tools for managing the virtual machine monitor in
  Red Hat Virtualization.
  
  It was discovered that the hypervisor's para-virtualized framebuffer (PVFB)
  backend failed to validate the frontend's framebuffer description properly.
  This could allow a privileged user in the unprivileged domain (DomU) to
  cause a denial of service, or, possibly, elevate privileges to the
  privileged domain (Dom0). (CVE-2008-1952)
  
  A flaw was found in the QEMU block format auto-detection, when running
  fully-virtualized guests and using Qemu images written on removable media
  (USB storage, 3.5&quot; disks). Privileged users of such fully-virtualized
  guests (DomU), with a raw-formatted disk image, were able to write a header
  to that disk image describing another format. This could allow such guests
  to read arbitrary files in their hypervisor's host (Dom0). (CVE-2008-1945)
  
  Additionally, the following bug is addressed in this update:
  
  * The qcow-create command terminated when invoked due to glibc bounds
  checking on the realpath() function.
  
  Users of xen are advised to upgrade to these updated packages, which
  resolve these security issues and fix this bug.


  Affected Software/OS:
  xen on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-October/msg00001.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xen");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"xen-debuginfo", rpm:"xen-debuginfo~3.0.3~64.el5_2.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xen-libs", rpm:"xen-libs~3.0.3~64.el5_2.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}