###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for IBMJava2 RHSA-2008:0133-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870143);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0133-01");
  script_cve_id("CVE-2007-3922", "CVE-2007-3004", "CVE-2007-3005");
  script_name(english: "RedHat Update for IBMJava2 RHSA-2008:0133-01");
  desc["english"] = "

  Vulnerability Insight:
  IBM's 1.3.1 Java release includes the IBM Java 2 Runtime Environment and
  the IBM Java 2 Software Development Kit.
  
  A buffer overflow was found in the Java Runtime Environment image-handling
  code. An untrusted applet or application could use this flaw to elevate its
  privileges and potentially execute arbitrary code as the user running the
  java virtual machine. (CVE-2007-3004)
  
  An unspecified vulnerability was discovered in the Java Runtime
  Environment. An untrusted applet or application could cause the java
  virtual machine to become unresponsive. (CVE-2007-3005)
  
  A flaw was found in the applet class loader. An untrusted applet could use
  this flaw to circumvent network access restrictions, possibly connecting to
  services hosted on the machine that executed the applet. (CVE-2007-3922)
  
  These updated packages also add the following enhancements:
  
  * Time zone information has been updated to the latest available
  information, 2007h.
  
  * Accessibility support in AWT can now be disabled through a system
  property, java.assistive.  To support this change,  permission to read this
  property must be added to /opt/IBMJava2-131/jre/lib/security/java.policy.
  Users of IBMJava2 who have modified this file should add this following
  line to the grant section:
  
  permission java.util.PropertyPermission &quot;java.assistive&quot;, &quot;read&quot;;
  
  All users of IBMJava2 should upgrade to these updated packages, which
  contain IBM's 1.3.1 SR11 Java release, which resolves these issues.


  Affected Software/OS:
  IBMJava2 on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-June/msg00018.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of IBMJava2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"IBMJava2-JRE", rpm:"IBMJava2-JRE~1.3.1~17", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava2-SDK", rpm:"IBMJava2-SDK~1.3.1~17", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}