#
#ADV FreeBSD-SA-08:11.arc4random.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-08:11.arc4random.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61921);
 script_cve_id("CVE-2008-5162");
 script_version ("$");
 name["english"] = "FreeBSD Security Advisory (FreeBSD-SA-08:11.arc4random.asc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-08:11.arc4random.asc

arc4random(9) is a generic-purpose random number generator based on the
key stream generator of the RC4 cipher.  It is expected to be
cryptographically strong, and used throughout the FreeBSD kernel for a
variety of purposes, some of which rely on its cryptographic strength.
arc4random(9) is periodically reseeded with entropy from the FreeBSD
kernel's Yarrow random number generator, which gathers entropy from a
variety of sources including hardware interrupts.  During the boot
process, additional entropy is provided to the Yarrow random number
generator from userland, helping to ensure that adequate entropy is
present for cryptographic purposes.
 
When the arc4random(9) random number generator is initialized, there may
be inadequate entropy to meet the needs of kernel systems which rely on
arc4random(9); and it may take up to 5 minutes before arc4random(9) is
reseeded with secure entropy from the Yarrow random number generator.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-08:11.arc4random.asc
Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Security Advisory (FreeBSD-SA-08:11.arc4random.asc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"7.0", patchlevel:"6")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.3", patchlevel:"6")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
