#
#VID 37940643-be1b-11dd-a578-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 37940643-be1b-11dd-a578-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61956);
 script_cve_id("CVE-2008-2940", "CVE-2008-2941");
 script_bugtraq_id(30683);
 script_version ("$");
 name["english"] = "FreeBSD Ports: hplip";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: hplip

CVE-2008-2940
The alert-mailing implementation in HP Linux Imaging and Printing
(HPLIP) 1.6.7 allows local users to gain privileges and send e-mail
messages from the root account via vectors related to the setalerts
message, and lack of validation of the device URI associated with an
event message.

CVE-2008-2941
The hpssd message parser in hpssd.py in HP Linux Imaging and Printing
(HPLIP) 1.6.7 allows local users to cause a denial of service (process
stop) via a crafted packet, as demonstrated by sending 'msg=0' to TCP
port 2207.

Solution:
Update your system with the appropriate patches or
software upgrades.

https://rhn.redhat.com/errata/RHSA-2008-0818.html
http://secunia.com/advisories/31470
http://www.vuxml.org/freebsd/37940643-be1b-11dd-a578-0030843d3802.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: hplip";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"hplip");
if(!isnull(bver) && revcomp(a:bver, b:"2.8.2_3")<0) {
    security_note(0, data:"Package hplip version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
