# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2784 (evolution-data-server)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63597);
 script_cve_id("CVE-2009-0547", "CVE-2009-0582");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-2784 (evolution-data-server)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to evolution-data-server
announced via advisory FEDORA-2009-2784.

Update Information:

This update fixes two security issues:

Evolution Data Server did not properly
check the Secure/Multipurpose Internet Mail Extensions (S/MIME) signatures used
for public key encryption and signing of e-mail messages. An attacker could use
this flaw to spoof a signature by modifying the text of the e-mail message
displayed to the user. (CVE-2009-0547)

It was discovered that Evolution Data
Server did not properly validate NTLM (NT LAN Manager) authentication challenge
packets. A malicious server using NTLM authentication could cause an application
using Evolution Data Server to disclose portions of its memory or crash during
user authentication. (CVE-2009-0582)

ChangeLog:

* Tue Mar 17 2009 Matthew Barnes  - 2.25.5-4.fc10
- Add patch for RH bug #484925 (CVE-2009-0547, S/MIME signatures).
- Add patch for RH bug #487685 (CVE-2009-0582, NTLM authentication).
* Fri Mar 13 2009 Matthew Barnes  - 2.25.5-3.fc10
- Revise patch for RH bug #568332 to match upstream commit.
* Thu Mar 12 2009 Matthew Barnes  - 2.25.5-2.fc10
- Add patch for RH bug #568332 (thread leak in fsync() rate limiting).

References:

[ 1 ] Bug #484925 - CVE-2009-0547 evolution-data-server: S/MIME signatures are considered to be valid even for modified messages (MITM)
https://bugzilla.redhat.com/show_bug.cgi?id=484925
[ 2 ] Bug #487685 - CVE-2009-0582 evolution-data-server: insufficient checking of NTLM authentication challenge packets
https://bugzilla.redhat.com/show_bug.cgi?id=487685

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update evolution-data-server' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2784

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-2784 (evolution-data-server)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~2.24.5~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~devel~2.24.5", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~doc~2.24.5", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~debuginfo~2.24.5", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
