# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0973 (asterisk)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63391);
 script_cve_id("CVE-2009-0041");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-0973 (asterisk)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to asterisk
announced via advisory FEDORA-2009-0973.

Update Information:

Add a patch to fix a problem with the manager interface.
Update to 1.6.0.5 to fix AST-2009-001 / CVE-2009-0041:
http://downloads.digium.com/pub/security/AST-2009-001.html
(Original patch in 1.6.0.3 introduced a regression.)

ChangeLog:

* Fri Jan 23 2009 Jeffrey C. Ollie  - 1.6.0.5-2
- Add a patch to fix a problem with the manager interface.
* Fri Jan 23 2009 Jeffrey C. Ollie  - 1.6.0.5-1
- Update to 1.6.0.5 to fix regressions caused by fixes for
AST-2009-001/CVE-2009-0041 (Asterisk 1.6.0.4 was never released).
* Thu Jan  8 2009 Jeffrey C. Ollie  - 1.6.0.3-1
- Update to 1.6.0.3 to fix AST-2009-001/CVE-2009-0041
- http://downloads.digium.com/pub/security/AST-2009-001.html
* Sun Jan  4 2009 Jeffrey C. Ollie  - 1.6.0.2-4
- Fedora Directory Server compatibility patch/subpackage. BZ#452176
* Sun Jan  4 2009 Jeffrey C. Ollie  - 1.6.0.2-3
- Don't package func_curl in the main package. BZ#475910
- Fix up paths. BZ#477238
* Sun Jan  4 2009 Jeffrey C. Ollie  - 1.6.0.2-2
- Add patch to fix compilation on PPC
* Sun Jan  4 2009 Jeffrey C. Ollie  - 1.6.0.2-1
- Update to 1.6.0.2

References:

[ 1 ] Bug #480132 - CVE-2009-0041 asterisk: Replies to failed login attempts differently based on whether the user account exists (information disclosure)
https://bugzilla.redhat.com/show_bug.cgi?id=480132

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update asterisk' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0973

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-0973 (asterisk)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"<td>asterisk", rpm:"<td>asterisk~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk", rpm:"asterisk~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-alsa", rpm:"asterisk-alsa~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-curl", rpm:"asterisk-curl~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-dahdi", rpm:"asterisk-dahdi~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-devel", rpm:"asterisk-devel~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-fax", rpm:"asterisk-fax~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-festival", rpm:"asterisk-festival~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-firmware", rpm:"asterisk-firmware~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-ices", rpm:"asterisk-ices~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-jabber", rpm:"asterisk-jabber~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-jack", rpm:"asterisk-jack~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-ldap", rpm:"asterisk-ldap~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-ldap-fds", rpm:"asterisk-ldap-fds~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-lua", rpm:"asterisk-lua~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-minivm", rpm:"asterisk-minivm~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-misdn", rpm:"asterisk-misdn~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-mobile", rpm:"asterisk-mobile~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-odbc", rpm:"asterisk-odbc~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-oss", rpm:"asterisk-oss~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-portaudio", rpm:"asterisk-portaudio~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-postgresql", rpm:"asterisk-postgresql~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-radius", rpm:"asterisk-radius~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-skinny", rpm:"asterisk-skinny~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-snmp", rpm:"asterisk-snmp~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-sqlite", rpm:"asterisk-sqlite~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-tds", rpm:"asterisk-tds~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-unistim", rpm:"asterisk-unistim~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-usbradio", rpm:"asterisk-usbradio~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail", rpm:"asterisk-voicemail~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail-imap", rpm:"asterisk-voicemail-imap~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail-odbc", rpm:"asterisk-voicemail-odbc~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail-plain", rpm:"asterisk-voicemail-plain~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-debuginfo", rpm:"asterisk-debuginfo~1.6.0.5~2.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
