# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2008-11923 (lighttpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63385);
 script_cve_id("CVE-2008-4298", "CVE-2008-4359", "CVE-2008-4360");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2008-11923 (lighttpd)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to lighttpd
announced via advisory FEDORA-2008-11923.


This update fixes some moderate security issues and includes a few enhancements.

ChangeLog:

* Wed Dec 24 2008 Matthias Saou  1.4.20-6
- Partially revert last change by creating a spawn-fastcgi symlink, so that
nothing breaks currently (especially for EL).
- Install empty poweredby image on RHEL since the symlink's target is missing.
- Split spawn-fcgi off in its own sub-package, have fastcgi package require it
to provide backwards compatibility.
* Mon Dec 22 2008 Matthias Saou  1.4.20-3
- Rename spawn-fastcgi to lighttpd-spawn-fastcgi to avoid clash with other
packages providing it for their own needs (#472749). It's not used as-is
by lighttpd, so it shouldn't be a problem... at worst, some custom scripts
will need to be updated.
* Mon Dec 22 2008 Matthias Saou  1.4.20-2
- Include conf.d/*.conf configuration snippets (#444953).
- Mark the default index.html in order to not loose changes upon upgrade if it
was edited or replaced with a different file (#438564).
- Include patch to add the INIT INFO block to the init script (#246973).

References:

[ 1 ] Bug #464637 - CVE-2008-4298 lighttpd: memory leak http_request_parse() in request.c
https://bugzilla.redhat.com/show_bug.cgi?id=464637
[ 2 ] Bug #465751 - CVE-2008-4359 lighttpd: bypass of rewrite/redirect rules using encoded urls
https://bugzilla.redhat.com/show_bug.cgi?id=465751
[ 3 ] Bug #465752 - CVE-2008-4360 lighttpd: mod_userdir information disclosure on case-insensitve filesystems
https://bugzilla.redhat.com/show_bug.cgi?id=465752

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update lighttpd' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2008-11923

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2008-11923 (lighttpd)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"lighttpd", rpm:"lighttpd~1.4.20~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-fastcgi", rpm:"lighttpd-fastcgi~1.4.20~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_geoip", rpm:"lighttpd-mod_geoip~1.4.20~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_mysql_vhost", rpm:"lighttpd-mod_mysql_vhost~1.4.20~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"spawn-fcgi", rpm:"spawn-fcgi~1.4.20~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-debuginfo", rpm:"lighttpd-debuginfo~1.4.20~6.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
