# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 971-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56277);
 script_cve_id("CVE-2006-0301");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 971-1 (xpdf)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xpdf
announced via advisory DSA 971-1.

SuSE researchers discovered heap overflow errors in xpdf, the Portable
Document Format (PDF) suite, that can allow attackers to cause a
denial of service by crashing the application or possibly execute
arbitrary code.

The old stable distribution (woody) is not affected.

For the stable distribution (sarge) these problems have been fixed in
version 3.00-13.5.

For the unstable distribution (sid) these problems have been fixed in
version 3.01-6.

We recommend that you upgrade your xpdf packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20971-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 971-1 (xpdf)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xpdf-common", ver:"3.00-13.5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf", ver:"3.00-13.5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf-reader", ver:"3.00-13.5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf-utils", ver:"3.00-13.5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
