# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 821-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55469);
 script_cve_id("CVE-2005-2491");
 script_bugtraq_id(14620);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 821-1 (python2.3)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to python2.3
announced via advisory DSA 821-1.

An integer overflow with a subsequent buffer overflow has been detected
in PCRE, the Perl Compatible Regular Expressions library, which allows
an attacker to execute arbitrary code, and is also present in Python.
Exploiting this vulnerability requires an attacker to specify the used
regular expression.

The old stable distribution (woody) does not contain python2.3 packages.

For the stable distribution (sarge) this problem has been fixed in
version 2.3.5-3sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 2.3.5-8.

We recommend that you upgrade your python2.3 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20821-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 821-1 (python2.3)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"idle-python2.3", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-doc", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-examples", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-dev", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-gdbm", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-mpz", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-tk", ver:"2.3.5-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
