# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 303-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53595);
 script_cve_id("CVE-2003-0073", "CVE-2003-0150");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 303-1 (mysql)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mysql
announced via advisory DSA 303-1.

CVE-2003-0073: The mysql package contains a bug whereby dynamically
allocated memory is freed more than once, which could be deliberately
triggered by an attacker to cause a crash, resulting in a denial of
service condition.  In order to exploit this vulnerability, a valid
username and password combination for access to the MySQL server is
required.

CVE-2003-0150: The mysql package contains a bug whereby a malicious
user, granted certain permissions within mysql, could create a
configuration file which would cause the mysql server to run as root,
or any other user, rather than the mysql user.

For the stable distribution (woody) both problems have been fixed in
version 3.23.49-8.4.

The old stable distribution (potato) is only affected by
CVE-2003-0150, and this has been fixed in version 3.22.32-6.4.

For the unstable distribution (sid), CVE-2003-0073 was fixed in
version 4.0.12-2, and CVE-2003-0150 will be fixed soon.

We recommend that you update your mysql package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20303-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 303-1 (mysql)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-common", ver:"3.23.49-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-doc", ver:"3.23.49-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10", ver:"3.23.49-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10-dev", ver:"3.23.49-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"3.23.49-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"3.23.49-8.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-doc", ver:"3.22.32-6.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"3.22.32-6.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"3.22.32-6.4", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
