# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 207-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53450);
 script_bugtraq_id(5978);
 script_cve_id("CVE-2002-0836");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 207-1 (tetex-bin)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tetex-bin
announced via advisory DSA 207-1.

The SuSE security team discovered a vulnerability in kpathsea library
(libkpathsea) which is used by xdvi and dvips.  Both programs call the
system() function insecurely, which allows a remote attacker to
execute arbitrary commands via cleverly crafted DVI files.

If dvips is used in a print filter, this allows a local or remote
attacker with print permission execute arbitrary code as the printer
user (usually lp).

This problem has been fixed in version 1.0.7+20011202-7.1for the
current stable distribution (woody), in version 1.0.6-7.3 for the old
stable distribution (potato) and in version 1.0.7+20021025-4 for the
unstable distribution (sid).  xdvik-ja and dvipsk-ja are vulnerable as
well, but link to the kpathsea library dynamically and will
automatically be fixed after a new libkpathsea is installed.

We recommend that you upgrade your tetex-lib package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20207-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 207-1 (tetex-bin)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tetex-bin", ver:"1.0.6-7.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tetex-dev", ver:"1.0.6-7.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tetex-lib", ver:"1.0.6-7.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkpathsea-dev", ver:"1.0.7+20011202-7.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkpathsea3", ver:"1.0.7+20011202-7.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tetex-bin", ver:"1.0.7+20011202-7.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
