# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 193-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53439);
 script_bugtraq_id(6157);
 script_cve_id("CVE-2002-1247");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 193-1 (kdenetwork)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdenetwork
announced via advisory DSA 193-1.

iDEFENSE reports a security vulnerability in the klisa package, that
provides a LAN information service similar to Network Neighbourhood,
which was discovered by Texonet.  It is possible for a local attacker
to exploit a buffer overflow condition in resLISa, a restricted
version of KLISa.  The vulnerability exists in the parsing of the
LOGNAME environment variable, an overly long value will overwrite the
instruction pointer thereby allowing an attacker to seize control of
the executable.

This problem has been fixed in version 2.2.2-14.2 the current stable
distribution (woody) and in version 2.2.2-14.3 for the unstable
distribution (sid).  The old stable distribution (potato) is not
affected since it doesn't contain a kdenetwork package

We recommend that you upgrade your klisa package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20193-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 193-1 (kdenetwork)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"klisa", ver:"2.2.2-14.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
