# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1756-1 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63728);
 script_cve_id("CVE-2009-1169", "CVE-2009-1044");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1756-1 (xulrunner)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xulrunner
announced via advisory DSA 1756-1.

Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications, such as the Iceweasel web
browser. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2009-1169

Security researcher Guido Landi discovered that a XSL stylesheet could
be used to crash the browser during a XSL transformation. An attacker
could potentially use this crash to run arbitrary code on a victim's
computer.

CVE-2009-1044

Security researcher Nils reported via TippingPoint's Zero Day Initiative
that the XUL tree method _moveToEdgeShift was in some cases triggering
garbage collection routines on objects which were still in use. In such
cases, the browser would crash when attempting to access a previously
destroyed object and this crash could be used by an attacker to run
arbitrary code on a victim's computer.

Note that after installing these updates, you will need to restart any
packages using xulrunner, typically iceweasel or epiphany.

For the stable distribution (lenny), these problems have been fixed in version
1.9.0.7-0lenny2.

As indicated in the Etch release notes, security support for the
Mozilla products in the oldstable distribution needed to be stopped
before the end of the regular Etch security maintenance life cycle.
You are strongly encouraged to upgrade to stable or switch to a still
supported browser.

For the unstable distribution (sid), these problems have been fixed in
version 1.9.0.8-1

We recommend that you upgrade your xulrunner package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201756-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1756-1 (xulrunner)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmozillainterfaces-java", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spidermonkey-bin", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d-dbg", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs-dev", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xpcom", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dbg", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.7-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
