# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1581-1 (gnutls13)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61034);
 script_cve_id("CVE-2008-1948", "CVE-2008-1949", "CVE-2008-1950");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1581-1 (gnutls13)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gnutls13
announced via advisory DSA 1581-1.

Several remote vulnerabilities have been discovered in GNUTLS, an
implementation of the SSL/TLS protocol suite.

NOTE: The libgnutls13 package, which provides the GNUTLS library, does
not contain logic to automatically restart potentially affected
services.  You must restart affected services manually (mainly Exim,
using /etc/init.d/exim4 restart) after applying the update, to make
the changes fully effective.  Alternatively, you can reboot the system.

The following vulnerabilities have been identified:

A pre-authentication heap overflow involving oversized session
resumption data may lead to arbitrary code execution (CVE-2008-1948).

Repeated client hellos may result in a pre-authentication denial of
service condition due to a null pointer dereference (CVE-2008-1949).

Decoding cipher padding with an invalid record length may cause GNUTLS
to read memory beyond the end of the received record, leading to a
pre-authentication denial of service condition (CVE-2008-1950).

For the stable distribution (etch), these problems have been fixed in
version 1.4.4-3+etch1.  (Builds for the arm architecture are currently
not available and will be released later.)

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your GNUTLS packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201581-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1581-1 (gnutls13)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnutls-doc", ver:"1.4.4-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls13", ver:"1.4.4-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls13-dbg", ver:"1.4.4-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls-dev", ver:"1.4.4-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnutls-bin", ver:"1.4.4-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
