# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1580-1 (phpgedview)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61033);
 script_cve_id("CVE-2008-2064");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1580-1 (phpgedview)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to phpgedview
announced via advisory DSA 1580-1.

It was discovered that phpGedView, an application to provide online access
to genealogical data, allowed remote attackers to gain administrator
privileges due to a programming error.

Note: this problem was a fundamental design flaw in the interface (API) to
connect phpGedView with external programs like content management systems.
Resolving this problem was only possible by completely reworking the API,
which is not considered appropriate for a security update. Since these are
peripheral functions probably not used by the large majority of package
users, it was decided to remove these interfaces. If you require that
interface nonetheless, you are advised to use a version of phpGedView
backported from Debian Lenny, which has a completely redesigned API.

For the stable distribution (etch), this problem has been fixed in
version 4.0.2.dfsg-4.

For the unstable distribution (sid), this problem has been fixed in
version 4.1.e+4.1.5-1.

We recommend that you upgrade your phpgedview package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201580-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1580-1 (phpgedview)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpgedview", ver:"4.0.2.dfsg-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgedview-languages", ver:"4.0.2.dfsg-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgedview-places", ver:"4.0.2.dfsg-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgedview-themes", ver:"4.0.2.dfsg-4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
