# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1131-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57201);
 script_cve_id("CVE-2006-3747");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1131-1 (apache)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to apache
announced via advisory DSA 1131-1.

Mark Dowd discovered a buffer overflow in the mod_rewrite component of
apache, a versatile high-performance HTTP server.  In some situations a
remote attacker could exploit this to execute arbitary code.

For the stable distribution (sarge) this problem has been fixed in version 1.3.33-6sarge2.

For the unstable distribution (sid) this problems will be fixed shortly.

We recommend that you upgrade your apache package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201131-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1131-1 (apache)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache-dev", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-doc", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-utils", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-common", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dbg", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-perl", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-ssl", ver:"1.3.33-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-perl", ver:"1.29.0.3-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
