###############################################################################
# OpenVAS Vulnerability Test
# $Id: GlassFish_34824.nasl 3309 2009-05-10 15:01:14Z mime $
#
# GlassFish Enterprise Server Multiple Cross Site Scripting
# Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100191);
 script_bugtraq_id(34824);
 script_version ("1.0");

 script_name(english:"GlassFish Enterprise Server Multiple Cross Site Scripting Vulnerabilities");
 desc["english"] = "

 Overview:
  GlassFish Enterprise Server is prone to multiple cross-site
  scripting vulnerabilities because it fails to sufficiently sanitize
  user-supplied input.

  Attacker-supplied HTML and script code would run in the context of
  the affected site, potentially allowing the attacker to steal
  cookie-based authentication credentials.

  GlassFish Enterprise Server 2.1 is vulnerable; other versions may
  also be affected.

 Solution:
  Updates are available. Please see https://glassfish.dev.java.net/ and/or
  http://www.sun.com/software/products/appsrvr/index.xml for more information.

 See also:
  http://www.securityfocus.com/bid/34824

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if GlassFish is vulnerable to XSS");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("GlassFish_detect.nasl");
 script_require_ports("Services/www", 8080);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:8080);

if(!get_port_state(port))exit(0);

if(get_kb_item(string("www/", port, "/GlassFishAdminConsole")))exit(0);
if(!vers = get_kb_item(string("www/", port, "/GlassFish")))exit(0);

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "2.1")) {
      security_warning(port:port);
      exit(0);
  }  

}

exit(0);
