/* Nessus
 * Copyright (C) 1998, 1999, 2000, 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 *
 * Implementation modified by Axel Nennker axel@nennker.de 20020306
 * Removed unused variables and format string errors.
 */

#ifndef __DATA_MINING_H__
#define __DATA_MINING_H__

#include <glib.h>

/*---------------------------------------------------------------*
 * Subset management  						 *
 *---------------------------------------------------------------*/

/**
 * @brief Result ("rows") of a query as list.
 */
struct subset
{
   struct subset * next;
   int num_fields;
   char ** data;
   unsigned int id_line; /**< Workaround to a primary key field, hold line number in nbe file for this row. */
};

/* Comparison function for subset_sort() */
typedef int(*cmp_func_t)(char*, char*);




struct subset * subset_next(struct subset*);
char * subset_value(struct subset*);
char * subset_nth_value(struct subset *, int);
int subset_size(struct subset*);
void subset_free(struct subset *);



struct subset * subset_sort(struct subset *, int, int, cmp_func_t*);
struct subset * subset_uniq(struct subset * , int);

struct subset * report_query_all_by_line    (int be, GSList* line_nr_list);
struct subset * report_query_single_by_line (int be, unsigned int line_nr);

struct subset * query_backend(int, char *, ...);


#endif
