//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Type
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTTYPE_HXX
#define OPENTURNS_OTTYPE_HXX

#include "BipartiteGraph.hxx"
#include "Cache.hxx"
#include "Collection.hxx"
#include "Description.hxx"
#include "IdentityMatrix.hxx"
#include "Indices.hxx"
#include "Matrix.hxx"
#include "MatrixImplementation.hxx"
#include "Mesh.hxx"
#include "NumericalPoint.hxx"
#include "NumericalPointWithDescription.hxx"
#include "PersistentCollection.hxx"
#include "SquareMatrix.hxx"
#include "SymmetricMatrix.hxx"
#include "SymmetricTensor.hxx"
#include "Tensor.hxx"
#include "TensorImplementation.hxx"
#include "ComplexTensorImplementation.hxx"
#include "ComplexTensor.hxx"
#include "DomainImplementation.hxx"
#include "Domain.hxx"
#include "Interval.hxx"
#include "ComplexMatrixImplementation.hxx"
#include "ComplexMatrix.hxx"
#include "HermitianMatrix.hxx"
#include "SquareComplexMatrix.hxx"
#include "TriangularMatrix.hxx"
#include "TriangularComplexMatrix.hxx"

#endif /* OPENTURNS_OTTYPE_HXX */
