"computeTestTwoSamplePearson" <-
function(numericalSample1, numericalSample2, testLevel = 0.95) {

  # Direct application of cor.test ('stats' package).
  testKs <- cor.test(numericalSample1, numericalSample2, method = "pearson")

  pValue <- testKs$p.value

  testResult <- ifelse(pValue > 1 - testLevel, 1, 0)
  return(list(test = "TwoSamplePearson",
              testResult = testResult,
              threshold = 1 - testLevel,
              pValue = pValue))
}

