#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    distribution = Bernoulli(0.7)
    size = 10000
    sample = distribution.getNumericalSample(size)
    factory = BernoulliFactory()
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    print "Estimated distribution=", repr(estimatedDistribution)

except :
  import sys
  print "t_BernoulliFactory.py", sys.exc_type, sys.exc_value
